/*
 * Decompiled with CFR 0.152.
 */
package com.xputertechnologies.santa.list;

import com.xputertechnologies.santa.PaymentBatch;
import com.xputertechnologies.santa.SearchClass;
import com.xputertechnologies.santa.core.DataAccess;
import com.xputertechnologies.santa.core.ParameterValue;
import com.xputertechnologies.santa.core.SearchCondition;
import com.xputertechnologies.santa.list.DataList;
import com.xputertechnologies.santa.list.StockItemList;
import com.xputertechnologies.santa.ui.General;
import java.sql.Date;
import java.sql.JDBCType;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PaymentBatchDataList
extends DataList<PaymentBatch> {
    int counter = 0;

    public PaymentBatchDataList(DataAccess dm) {
        this.t = new PaymentBatch(dm);
    }

    public PaymentBatchDataList() {
    }

    @Override
    public void select() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void selectAll(String query, ParameterValue[] param) {
        try {
            DataAccess dt = this.getDataAccess();
            this.getOriginalList().clear();
            ResultSet rs = dt.select(query, param);
            if (rs != null) {
                while (rs.next()) {
                    PaymentBatch approval = new PaymentBatch(rs.getString("batchCode"), rs.getDate("dateCreated"), rs.getString("batchUser"), rs.getString("status"), rs.getBoolean("syncFlag"), rs.getString("store"), rs.getDouble("amount"), rs.getString("tellerNo"), rs.getString("syncError"), rs.getString("remark"), rs.getDouble("amountNotCash"), rs.getString("accountNo"), rs.getString("bankName"), rs.getDouble("amountDeposited"), this.getDataAccess());
                    approval.loadSales();
                    approval.vClone = approval.clone();
                    this.getOriginalList().add((Object)approval);
                }
                rs.close();
                dt.closeConnection();
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(PaymentBatchDataList.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public static PaymentBatchDataList SearchByDate(Date FromDate, Date ToDate, DataAccess dt) {
        java.util.Date start = new java.util.Date(FromDate.getYear(), FromDate.getMonth(), FromDate.getDate(), 0, 0, 0);
        java.util.Date end = new java.util.Date(ToDate.getYear(), ToDate.getMonth(), ToDate.getDate(), 23, 59, 0);
        String query = "Select * from PaymentBatch where dateCreated between ? and ?  ORDER by batchCode DESC";
        PaymentBatchDataList paymentBatchDataList = new PaymentBatchDataList(dt);
        paymentBatchDataList.selectAll(query, new ParameterValue[]{new ParameterValue("dateCreated", JDBCType.TIMESTAMP, new Timestamp(start.getTime())), new ParameterValue("dateCreated", JDBCType.TIMESTAMP, new Timestamp(end.getTime()))});
        return paymentBatchDataList;
    }

    public static List<PaymentBatch> selectAllPendingPostingPaymentBaqtch(DataAccess da) {
        ArrayList<PaymentBatch> result = new ArrayList<PaymentBatch>();
        try {
            ResultSet rs = da.select("SELECT * FROM PaymentBatch WHERE (tellerNo IS NOT NULL AND TRIM(tellerNo) <> '') and syncFlag=?", new ParameterValue[]{new ParameterValue("syncFlag", JDBCType.CHAR, false)});
            if (rs != null) {
                while (rs.next()) {
                    PaymentBatch approval = new PaymentBatch(rs.getString("batchCode"), rs.getDate("dateCreated"), rs.getString("batchUser"), rs.getString("status"), rs.getBoolean("syncFlag"), rs.getString("store"), rs.getDouble("amount"), rs.getString("tellerNo"), rs.getString("syncError"), rs.getString("remark"), rs.getDouble("amountNotCash"), rs.getString("accountNo"), rs.getString("bankName"), rs.getDouble("amountDeposited"), da);
                    approval.loadSales();
                    approval.vClone = approval.clone();
                    result.add(approval);
                }
                rs.close();
                da.closeConnection();
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(PaymentBatchDataList.class.getName()).log(Level.SEVERE, null, ex);
        }
        return result;
    }

    public void resetNumbering() {
        this.counter = 0;
        this.getOriginalList().forEach(val -> {
            ++this.counter;
            val.setSn(this.counter);
        });
    }

    public void selectAll(DataAccess da) {
        try {
            DataAccess dt = da;
            this.getOriginalList().clear();
            ResultSet rs = dt.select("Select * from PaymentBatch", da.getEmptyParameterValues());
            if (rs != null) {
                while (rs.next()) {
                    PaymentBatch approval = new PaymentBatch(rs.getString("batchCode"), rs.getDate("dateCreated"), rs.getString("batchUser"), rs.getString("status"), rs.getBoolean("syncFlag"), rs.getString("store"), rs.getDouble("amount"), rs.getString("tellerNo"), rs.getString("syncError"), rs.getString("remark"), rs.getDouble("amountNotCash"), rs.getString("accountNo"), rs.getString("bankName"), rs.getDouble("amountDeposited"), this.getDataAccess());
                    approval.loadSales();
                    approval.vClone = approval.clone();
                    this.getOriginalList().add((Object)approval);
                }
                rs.close();
                dt.closeConnection();
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(PaymentBatchDataList.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public void select(SearchCondition searchCondition, boolean forward, boolean reset) {
        DataAccess dt = this.getDataAccess();
        if (reset) {
            this.currentPage = 0;
        }
        Object query = "Select  * From PaymentBatch Where ";
        for (ParameterValue pv : searchCondition.getParametersvalues()) {
            query = (String)query + pv.getParameterName() + " like ? or ";
        }
        query = ((String)query).substring(0, ((String)query).length() - 3);
        Objects.requireNonNull(this);
        query = (String)query + "order by name ASC Limit " + 50 + " Offset " + this.currentPage;
        ParameterValue[] parameterValue = searchCondition.ConvertoparameterValuesArray();
        ResultSet rs = dt.select((String)query, parameterValue);
        try {
            if (rs != null) {
                while (rs.next()) {
                    PaymentBatch approval = new PaymentBatch(rs.getString("batchCode"), rs.getDate("dateCreated"), rs.getString("batchUser"), rs.getString("status"), rs.getBoolean("syncFlag"), rs.getString("store"), rs.getDouble("amount"), rs.getString("tellerNo"), rs.getString("syncError"), rs.getString("remark"), rs.getDouble("amountNotCash"), rs.getString("accountNo"), rs.getString("bankName"), rs.getDouble("amountDeposited"), this.getDataAccess());
                    approval.loadSales();
                    approval.vClone = approval.clone();
                    this.getOriginalList().add((Object)approval);
                }
                this.currentPage = forward ? ++this.currentPage : (this.currentPage > 0 ? (this.currentPage = this.currentPage - 1) : 0);
                rs.close();
                dt.closeConnection();
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(StockItemList.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public static ArrayList<SearchClass> searchAutoComplete(String searchString, DataAccess dt) throws SQLException {
        ParameterValue[] parameterValue;
        ArrayList<SearchClass> result = new ArrayList<SearchClass>();
        ArrayList<ParameterValue> tempParamValue = new ArrayList<ParameterValue>();
        tempParamValue.add(new ParameterValue("batchCode", JDBCType.VARCHAR, "%" + searchString + "%"));
        tempParamValue.add(new ParameterValue("tellerNo", JDBCType.VARCHAR, "%" + searchString + "%"));
        tempParamValue.add(new ParameterValue("batchUser", JDBCType.VARCHAR, "%" + searchString + "%"));
        SearchCondition searchCondition = new SearchCondition();
        searchCondition.setParametersvalues(tempParamValue);
        Object query = "Select batchCode,tellerNo,amount from PaymentBatch Where ";
        for (ParameterValue pv : searchCondition.getParametersvalues()) {
            query = (String)query + pv.getParameterName() + " like ? or ";
        }
        query = ((String)query).substring(0, ((String)query).length() - 3);
        ResultSet rs = dt.select((String)(query = (String)query + "order by batchCode ASC"), parameterValue = searchCondition.ConvertoparameterValuesArray());
        if (rs != null) {
            try {
                while (rs.next()) {
                    String teller = rs.getString("tellerNo");
                    String va = rs.getString("batchCode") + "-Amt:" + General.formatDecimalToMoneyString(rs.getDouble("amount"));
                    va = va + (String)(teller == null || teller.isEmpty() ? "" : "(" + teller + ")");
                    result.add(new SearchClass(rs.getString("batchCode"), va));
                }
                rs.close();
                dt.closeConnection();
            }
            catch (Exception ex) {
                if (rs != null) {
                    rs.close();
                    dt.closeConnection();
                }
                Logger.getLogger(StockItemList.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return result;
    }
}

