/*
 * Decompiled with CFR 0.152.
 */
package com.xputertechnologies.santa.list;

import com.xputertechnologies.santa.Employee;
import com.xputertechnologies.santa.core.DataAccess;
import com.xputertechnologies.santa.core.ParameterValue;
import com.xputertechnologies.santa.core.SearchCondition;
import com.xputertechnologies.santa.list.DataList;
import com.xputertechnologies.santa.list.StockItemList;
import com.xputertechnologies.santa.list.UserDataList;
import java.sql.JDBCType;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;

public class EmployeeDataList
extends DataList<Employee> {
    public EmployeeDataList(DataAccess da) {
        this.t = new Employee(da);
    }

    public EmployeeDataList() {
    }

    @Override
    public void select() {
    }

    public void selectAll(String query, DataAccess da) {
        try {
            this.getOriginalList().clear();
            ResultSet rs = da.select(query, da.getEmptyParameterValues());
            if (rs != null) {
                while (rs.next()) {
                    Employee request = new Employee(rs.getString("empId"), rs.getString("empName"), this.getDataAccess());
                    request.setSn(this.getOriginalList().size() + 1);
                    request.vClone = request.clone();
                    this.getOriginalList().add((Object)request);
                }
                rs.close();
                da.closeConnection();
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(UserDataList.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public void selectAll(String query, ParameterValue[] param) {
        try {
            this.getOriginalList().clear();
            ResultSet rs = this.getDataAccess().select(query, param);
            if (rs != null) {
                while (rs.next()) {
                    Employee request = new Employee(rs.getString("empId"), rs.getString("empName"), this.getDataAccess());
                    request.vClone = request.clone();
                    this.getOriginalList().add((Object)request);
                }
                rs.close();
                this.getDataAccess().closeConnection();
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(UserDataList.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public static ArrayList<Employee> selectAutoCompleteSalesRep(String searchString, DataAccess dt, Boolean productOnly) throws SQLException {
        ParameterValue[] parameterValue;
        ArrayList<Employee> result = new ArrayList<Employee>();
        ArrayList<ParameterValue> tempParamValue = new ArrayList<ParameterValue>();
        tempParamValue.add(new ParameterValue("empName", JDBCType.VARCHAR, "%" + searchString + "%"));
        tempParamValue.add(new ParameterValue("empId", JDBCType.VARCHAR, "%" + searchString + "%"));
        SearchCondition searchCondition = new SearchCondition();
        searchCondition.setParametersvalues(tempParamValue);
        Object query = "Select Distinct * From Employee Where ";
        for (ParameterValue pv : searchCondition.getParametersvalues()) {
            query = (String)query + pv.getParameterName() + " like ? or ";
        }
        query = ((String)query).substring(0, ((String)query).length() - 3);
        ResultSet rs = dt.select((String)(query = (String)query + "order by empName ASC"), parameterValue = searchCondition.ConvertoparameterValuesArray());
        if (rs != null) {
            try {
                while (rs.next()) {
                    result.add(new Employee(rs.getString("empId"), rs.getString("empName"), dt));
                }
                rs.close();
                dt.closeConnection();
            }
            catch (Exception ex) {
                if (rs != null) {
                    rs.close();
                    dt.closeConnection();
                }
                Logger.getLogger(StockItemList.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return result;
    }

    @Override
    public void select(SearchCondition searchCondition, boolean forward, boolean reset) {
        DataAccess dt = this.getDataAccess();
        if (reset) {
            this.currentPage = 0;
        }
        Object query = "Select  * From Employee Where ";
        for (ParameterValue pv : searchCondition.getParametersvalues()) {
            query = (String)query + pv.getParameterName() + " like ? or ";
        }
        query = ((String)query).substring(0, ((String)query).length() - 3);
        Objects.requireNonNull(this);
        query = (String)query + "order by empId ASC Limit " + 50 + " Offset " + this.currentPage;
        ParameterValue[] parameterValue = searchCondition.ConvertoparameterValuesArray();
        ResultSet rs = dt.select((String)query, parameterValue);
        try {
            if (rs != null) {
                while (rs.next()) {
                    Employee request = new Employee(rs.getString("empId"), rs.getString("empName"), this.getDataAccess());
                    request.vClone = request.clone();
                    this.getOriginalList().add((Object)request);
                }
                this.currentPage = forward ? ++this.currentPage : (this.currentPage > 0 ? (this.currentPage = this.currentPage - 1) : 0);
                rs.close();
                dt.closeConnection();
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(StockItemList.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public static void deleteAll(DataAccess da) throws Exception {
        da.performDbOperation("Delete From Employee", da.getEmptyParameterValues());
    }
}

