/*
 * Decompiled with CFR 0.152.
 */
package com.xputertechnologies.santa.list;

import com.xputertechnologies.santa.Customer;
import com.xputertechnologies.santa.SearchClass;
import com.xputertechnologies.santa.core.DataAccess;
import com.xputertechnologies.santa.core.ParameterValue;
import com.xputertechnologies.santa.core.SearchCondition;
import com.xputertechnologies.santa.list.CompanyDataList;
import com.xputertechnologies.santa.list.DataList;
import java.sql.JDBCType;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CustomerDataList
extends DataList<Customer> {
    public DataAccess dataAccess;

    public CustomerDataList(DataAccess d) {
        this.dataAccess = d;
        this.t = new Customer(d);
    }

    public CustomerDataList() {
    }

    @Override
    public void select() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void SelectAll() {
        try {
            this.getOriginalList().clear();
            ResultSet rs = this.getDataAccess().select("Select * from Customer", this.getDataAccess().getEmptyParameterValues());
            int i = 1;
            if (rs != null) {
                while (rs.next()) {
                    Customer customer = new Customer(rs.getString("code"), rs.getString("d365Code"), rs.getDate("dateCreated"), rs.getString("email"), rs.getString("name"), rs.getString("phoneNumber"), rs.getString("address"), rs.getString("companyName"), this.dataAccess);
                    customer.setSn(i);
                    customer.vClone = customer.clone();
                    this.getOriginalList().add((Object)customer);
                    ++i;
                }
                rs.close();
                this.getDataAccess().closeConnection();
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(CompanyDataList.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public void selectAll(String query, ParameterValue[] param) {
        try {
            this.getOriginalList().clear();
            ResultSet rs = this.dataAccess.select(query, param);
            if (rs != null) {
                int i = 1;
                while (rs.next()) {
                    Customer customer = new Customer(rs.getString("code"), rs.getString("d365Code"), rs.getDate("dateCreated"), rs.getString("email"), rs.getString("name"), rs.getString("phoneNumber"), rs.getString("address"), rs.getString("companyName"), this.dataAccess);
                    customer.setSn(i);
                    customer.vClone = customer.clone();
                    this.getOriginalList().add((Object)customer);
                    ++i;
                }
                rs.close();
                this.dataAccess.closeConnection();
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(CompanyDataList.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public void select(SearchCondition searchCondition, boolean forward, boolean reset) {
        Object query = "SELECT * FROM CUSTOMER WHERE ";
        for (ParameterValue p : searchCondition.getParametersvalues()) {
            query = (String)query + p.getParameterName() + " like ? or ";
        }
        query = ((String)query).substring(0, ((String)query).length() - 3);
        Objects.requireNonNull(this);
        query = (String)query + "order by name ASC Limit " + 50 + " Offset " + this.currentPage;
        ParameterValue[] parameterValue = searchCondition.ConvertoparameterValuesArray();
        try {
            ResultSet rs = this.dataAccess.select((String)query, parameterValue);
            if (rs != null) {
                int i = 1;
                while (rs.next()) {
                    Customer customer = new Customer(rs.getString("code"), rs.getString("d365Code"), rs.getDate("dateCreated"), rs.getString("email"), rs.getString("name"), rs.getString("phoneNumber"), rs.getString("address"), rs.getString("companyName"), this.dataAccess);
                    customer.setSn(i);
                    customer.vClone = customer.clone();
                    this.getOriginalList().add((Object)customer);
                    ++i;
                }
                this.currentPage = forward ? ++this.currentPage : (this.currentPage > 0 ? (this.currentPage = this.currentPage - 1) : 0);
                rs.close();
                this.dataAccess.closeConnection();
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(CustomerDataList.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (Exception ex) {
            Logger.getLogger(CustomerDataList.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public static ArrayList<SearchClass> selectAutoComplete(String searchString, DataAccess dt) throws SQLException {
        ParameterValue[] parameterValue;
        ArrayList<SearchClass> result = new ArrayList<SearchClass>();
        ArrayList<ParameterValue> tempParamValue = new ArrayList<ParameterValue>();
        tempParamValue.add(new ParameterValue("email", JDBCType.VARCHAR, "%" + searchString + "%"));
        tempParamValue.add(new ParameterValue("name", JDBCType.VARCHAR, "%" + searchString + "%"));
        tempParamValue.add(new ParameterValue("phoneNumber", JDBCType.VARCHAR, "%" + searchString + "%"));
        tempParamValue.add(new ParameterValue("address", JDBCType.VARCHAR, "%" + searchString + "%"));
        SearchCondition searchCondition = new SearchCondition();
        searchCondition.setParametersvalues(tempParamValue);
        Object query = "Select Distinct * From Customer Where ";
        for (ParameterValue pv : searchCondition.getParametersvalues()) {
            query = (String)query + pv.getParameterName() + " like ? or ";
        }
        query = ((String)query).substring(0, ((String)query).length() - 3);
        ResultSet rs = dt.select((String)(query = (String)query + "order by email ASC"), parameterValue = searchCondition.ConvertoparameterValuesArray());
        if (rs != null) {
            try {
                while (rs.next()) {
                    result.add(new SearchClass(rs.getString("phoneNumber"), rs.getString("name") + "[" + rs.getString("phoneNumber") + "]"));
                }
                rs.close();
                dt.closeConnection();
            }
            catch (Exception ex) {
                if (rs != null) {
                    rs.close();
                    dt.closeConnection();
                }
                Logger.getLogger(CustomerDataList.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return result;
    }

    public static void deleteAll(DataAccess da) throws Exception {
        da.performDbOperation("Delete From Customer", da.getEmptyParameterValues());
    }
}

