/*
 * Decompiled with CFR 0.152.
 */
package com.xputertechnologies.santa.list;

import com.xputertechnologies.santa.AccountPaymentType;
import com.xputertechnologies.santa.BatchSale;
import com.xputertechnologies.santa.SearchClass;
import com.xputertechnologies.santa.core.DataAccess;
import com.xputertechnologies.santa.core.ParameterValue;
import com.xputertechnologies.santa.core.SearchCondition;
import com.xputertechnologies.santa.list.DataList;
import com.xputertechnologies.santa.list.SaleList;
import com.xputertechnologies.santa.list.StockItemList;
import java.sql.Date;
import java.sql.JDBCType;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BatchSaleDataList
extends DataList<BatchSale> {
    public BatchSaleDataList(DataAccess dm) {
        this.t = new BatchSale(dm);
    }

    public BatchSaleDataList() {
    }

    @Override
    public void select() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void selectAll(String query, ParameterValue[] param) {
        try {
            DataAccess dt = this.getDataAccess();
            this.getOriginalList().clear();
            ResultSet rs = dt.select(query, param);
            if (rs != null) {
                while (rs.next()) {
                    BatchSale approval = new BatchSale(rs.getString("invoiceNumber"), rs.getString("batchCode"), rs.getString("salesChannel"), rs.getDouble("amount"), rs.getDouble("amountNotCash"), this.getDataAccess());
                    approval.vClone = approval.clone();
                    this.getOriginalList().add((Object)approval);
                }
                rs.close();
                dt.closeConnection();
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(BatchSaleDataList.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public static BatchSaleDataList SearchSaleNotBatch(String invNo, Date FromDate, Date ToDate, DataAccess dt) {
        BatchSaleDataList saleLst = new BatchSaleDataList(dt);
        try {
            ResultSet rslt;
            String query;
            if (invNo.isEmpty()) {
                java.util.Date start = new java.util.Date(FromDate.getYear(), FromDate.getMonth(), FromDate.getDate(), 0, 0, 0);
                java.util.Date end = new java.util.Date(ToDate.getYear(), ToDate.getMonth(), ToDate.getDate(), 23, 59, 0);
                query = "Select Sale.invoiceNumber,Sale.AMOUNTPAID as TotalAmount,description,SALEACCOUNTDETAILRESOLVER.amountPaid,SALEACCOUNTDETAILRESOLVER.accType  from Sale join SALEACCOUNTDETAILRESOLVER on Sale.INVOICENUMBER=SALEACCOUNTDETAILRESOLVER.INVOICENUMBER join SaleChannel on Sale.SalesChannel=SaleChannel.Code where Sale.INVOICENUMBER not in (Select  invoiceNumber from  BatchSale ) and (\"date\" between ? and ?)   order by Sale.INVOICENUMBER";
                rslt = dt.select(query, new ParameterValue[]{new ParameterValue("date", JDBCType.TIMESTAMP, new Timestamp(start.getTime())), new ParameterValue("date", JDBCType.TIMESTAMP, new Timestamp(end.getTime()))});
            } else {
                query = "Select Sale.invoiceNumber,Sale.AMOUNTPAID as TotalAmount,description,SALEACCOUNTDETAILRESOLVER.amountPaid,SALEACCOUNTDETAILRESOLVER.accType  from Sale join SALEACCOUNTDETAILRESOLVER on Sale.INVOICENUMBER=SALEACCOUNTDETAILRESOLVER.INVOICENUMBER join SaleChannel on Sale.SalesChannel=SaleChannel.Code where Sale.INVOICENUMBER not in (Select  invoiceNumber from  BatchSale ) and (Sale.invoiceNumber=?) order by Sale.INVOICENUMBER";
                rslt = dt.select(query, new ParameterValue[]{new ParameterValue("invoice", JDBCType.VARCHAR, invNo)});
            }
            if (rslt != null) {
                while (rslt.next()) {
                    String invoice = rslt.getString("invoiceNumber");
                    String channel = rslt.getString("description");
                    double amountPaid = rslt.getDouble("amountPaid");
                    String accType = rslt.getString("accType");
                    BatchSale found = saleLst.getOriginalList().stream().filter(val -> val.getInvoiceNumber().equals(invoice)).findAny().orElse(null);
                    if (found != null) {
                        if (accType.equals(AccountPaymentType.Cash.name())) {
                            found.setAmount(found.getAmount() + amountPaid);
                            continue;
                        }
                        found.setAmountNotCash(found.getAmountNotCash() + amountPaid);
                        continue;
                    }
                    found = new BatchSale(dt);
                    found.setInvoiceNumber(invoice);
                    found.setSalesChannel(channel);
                    if (accType.equals(AccountPaymentType.Cash.name())) {
                        found.setAmount(amountPaid);
                    } else {
                        found.setAmountNotCash(amountPaid);
                    }
                    saleLst.getOriginalList().add((Object)found);
                }
                rslt.close();
            }
        }
        catch (Exception ex) {
            Logger.getLogger(SaleList.class.getName()).log(Level.SEVERE, null, ex);
        }
        return saleLst;
    }

    public static ArrayList<SearchClass> selectAutoComplete(String searchString, DataAccess dt) throws SQLException {
        ParameterValue[] parameterValue;
        ArrayList<SearchClass> result = new ArrayList<SearchClass>();
        ArrayList<ParameterValue> tempParamValue = new ArrayList<ParameterValue>();
        tempParamValue.add(new ParameterValue("Sale.invoiceNumber", JDBCType.VARCHAR, "%" + searchString + "%"));
        tempParamValue.add(new ParameterValue("sellingStaff", JDBCType.VARCHAR, "%" + searchString + "%"));
        SearchCondition searchCondition = new SearchCondition();
        searchCondition.setParametersvalues(tempParamValue);
        Object query = "Select Sale.invoiceNumber,Sale.AMOUNTPAID as TotalAmount,salesChannel from Sale  where Sale.INVOICENUMBER not in (Select  invoiceNumber from  BatchSale ) and (";
        for (ParameterValue pv : searchCondition.getParametersvalues()) {
            query = (String)query + pv.getParameterName() + " like ? or ";
        }
        query = ((String)query).substring(0, ((String)query).length() - 3);
        ResultSet rs = dt.select((String)(query = (String)query + ") and sale.CreditToken  is null or  sale.CreditToken ='' order by Sale.INVOICENUMBER ASC"), parameterValue = searchCondition.ConvertoparameterValuesArray());
        if (rs != null) {
            try {
                while (rs.next()) {
                    result.add(new SearchClass(rs.getString("invoiceNumber"), rs.getString("invoiceNumber")));
                }
                rs.close();
                dt.closeConnection();
            }
            catch (Exception ex) {
                if (rs != null) {
                    rs.close();
                    dt.closeConnection();
                }
                Logger.getLogger(StockItemList.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return result;
    }

    public void selectAll(DataAccess da) {
        try {
            DataAccess dt = da;
            this.getOriginalList().clear();
            ResultSet rs = dt.select("Select * from PaymentBatch", da.getEmptyParameterValues());
            if (rs != null) {
                while (rs.next()) {
                    BatchSale approval = new BatchSale(rs.getString("invoiceNo"), rs.getString("batchCode"), rs.getString("salesChannel"), rs.getDouble("amount"), rs.getDouble("amountNotCash"), this.getDataAccess());
                    approval.vClone = approval.clone();
                    this.getOriginalList().add((Object)approval);
                }
                rs.close();
                da.closeConnection();
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(BatchSaleDataList.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public void select(SearchCondition searchCondition, boolean forward, boolean reset) {
        DataAccess dt = this.getDataAccess();
        if (reset) {
            this.currentPage = 0;
        }
        Object query = "Select  * From PaymentBatch Where ";
        for (ParameterValue pv : searchCondition.getParametersvalues()) {
            query = (String)query + pv.getParameterName() + " like ? or ";
        }
        query = ((String)query).substring(0, ((String)query).length() - 3);
        Objects.requireNonNull(this);
        query = (String)query + "order by name ASC Limit " + 50 + " Offset " + this.currentPage;
        ParameterValue[] parameterValue = searchCondition.ConvertoparameterValuesArray();
        ResultSet rs = dt.select((String)query, parameterValue);
        try {
            if (rs != null) {
                while (rs.next()) {
                    BatchSale approval = new BatchSale(rs.getString("invoiceNo"), rs.getString("batchCode"), rs.getString("salesChannel"), rs.getDouble("amount"), rs.getDouble("amountNotCash"), this.getDataAccess());
                    approval.vClone = approval.clone();
                    this.getOriginalList().add((Object)approval);
                }
                this.currentPage = forward ? ++this.currentPage : (this.currentPage > 0 ? (this.currentPage = this.currentPage - 1) : 0);
                rs.close();
                dt.closeConnection();
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(StockItemList.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}

