/*
 * Decompiled with CFR 0.152.
 */
package com.xputertechnologies.santa.core;

import com.xputertechnologies.santa.User;
import com.xputertechnologies.santa.core.BaseConcurrencyException;
import com.xputertechnologies.santa.core.ParameterValue;
import com.xputertechnologies.santa.ui.Santa;
import java.io.File;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.JDBCType;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.sqlite.SQLiteConfig;

public class DataAccess {
    Boolean isDevelopment = true;
    private User user;
    boolean inTransaction = false;
    public String userId;
    private ParameterValue[] eParameters = new ParameterValue[0];
    private PreparedStatement generalCommand;
    public Connection dbConnect;
    String conStr;

    public DataAccess(String connectionString, String userId) {
        this.userId = userId;
        this.conStr = connectionString;
        if (!connectionString.isEmpty()) {
            this.makeConnection(connectionString);
        }
    }

    public DataAccess() {
        this.makeConnection();
    }

    public void makeConnection(String connectionString) {
        this.conStr = connectionString;
        this.makeConnection();
    }

    public void setUpClass() throws Exception {
        Class.forName("org.firebirdsql.jdbc.FBDriver");
        try {
            Class.forName("org.sqlite.JDBC");
            SQLiteConfig config = new SQLiteConfig();
            config.setLockingMode(SQLiteConfig.LockingMode.EXCLUSIVE);
            config.setJournalMode(SQLiteConfig.JournalMode.WAL);
            if (this.isDevelopment.booleanValue()) {
                this.dbConnect = DriverManager.getConnection("jdbc:sqlite:/Users/akintunde/NetBeansProjects/YuvendRetail/DB/SANTA.db", config.toProperties());
            }
        }
        catch (Exception ex) {
            System.out.println("Error from SetupClass" + ex.getMessage());
        }
    }

    public void makeConnection() {
        try {
            if (this.dbConnect == null || this.dbConnect.isClosed()) {
                SQLiteConfig config = new SQLiteConfig();
                config.setSynchronous(SQLiteConfig.SynchronousMode.NORMAL);
                config.setJournalMode(SQLiteConfig.JournalMode.WAL);
                this.conStr = Santa.isDevelopment ? "jdbc:sqlite:C:\\Users\\Akintunde\\Documents\\NetBeansProjects\\YuvendRetail\\Db\\SANTA.db" : (System.getProperty("os.name").indexOf("Mac OS X") >= 0 ? "jdbc:sqlite:" + File.separator + this.getClass().getProtectionDomain().getCodeSource().getLocation().getPath().replace("Santa.jar", "Db/SANTA.db").substring(1) : "jdbc:sqlite:" + this.getClass().getProtectionDomain().getCodeSource().getLocation().getPath().replace("Santa.jar", "Db/SANTA.db").substring(1));
                this.dbConnect = DriverManager.getConnection(this.conStr, config.toProperties());
                this.dbConnect.setAutoCommit(true);
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(DataAccess.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public DataAccess(Connection connection, String userId) {
        this.userId = userId;
        this.dbConnect = connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet select(String commandText, ParameterValue[] paras) {
        ResultSet rd = null;
        try {
            if (!commandText.isEmpty()) {
                this.makeConnection();
                this.generalCommand = this.dbConnect.prepareStatement(commandText);
                this.loadParameters(paras);
                rd = this.generalCommand.executeQuery();
            }
        }
        catch (SQLException ex) {
            String string = ex.getMessage();
        }
        return rd;
    }

    public void closeConnection() throws SQLException, SQLException {
        try {
            if (this.dbConnect != null && !this.dbConnect.isClosed()) {
                this.dbConnect.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public int performTableDDLOperation(String qry) throws Exception {
        int ct = 0;
        Statement statement = null;
        try {
            this.makeConnection();
            statement = this.dbConnect.createStatement();
            statement.execute(qry);
        }
        catch (SQLException xp) {
            this.closeConnection();
            throw xp;
        }
        finally {
            if (statement != null) {
                if (!this.inTransaction) {
                    this.closeConnection();
                } else {
                    statement.close();
                }
            }
        }
        return ct;
    }

    public int[] performDbOperationBatch(String qry, List<ParameterValue[]> parameters) throws Exception {
        int[] ct = new int[]{0};
        try {
            this.makeConnection();
            this.generalCommand = this.dbConnect.prepareStatement(qry);
            for (ParameterValue[] parameter : parameters) {
                this.loadParameters(parameter);
                this.generalCommand.addBatch();
            }
            ct = this.generalCommand.executeBatch();
        }
        catch (Exception xp) {
            if (this.inTransaction) {
                this.rollBack();
            } else {
                this.closeConnection();
            }
            throw new BaseConcurrencyException(xp.getMessage());
        }
        finally {
            try {
                if (!this.inTransaction) {
                    this.closeConnection();
                } else {
                    this.generalCommand.close();
                }
            }
            catch (SQLException ex1) {
                Logger.getLogger(DataAccess.class.getName()).log(Level.SEVERE, null, ex1);
            }
        }
        return ct;
    }

    public int performDbOperation(String qry, ParameterValue[] parameters) throws Exception {
        int ct = 0;
        try {
            this.makeConnection();
            this.generalCommand = this.dbConnect.prepareStatement(qry);
            this.loadParameters(parameters);
            ct = this.generalCommand.executeUpdate();
        }
        catch (SQLException xp) {
            if (this.inTransaction) {
                this.rollBack();
            } else {
                this.closeConnection();
            }
            throw new BaseConcurrencyException(xp.getMessage());
        }
        finally {
            try {
                if (!this.inTransaction) {
                    this.closeConnection();
                }
            }
            catch (SQLException ex1) {
                Logger.getLogger(DataAccess.class.getName()).log(Level.SEVERE, null, ex1);
            }
        }
        return ct;
    }

    public int performDbOperation(String qry, ParameterValue[] parameters, boolean chkConcurency) throws Exception {
        int count = 0;
        String exception = "Unable to perform data update";
        try {
            this.makeConnection();
            this.generalCommand = this.dbConnect.prepareStatement(qry);
            this.generalCommand.clearParameters();
            this.loadParameters(parameters);
            count = this.generalCommand.executeUpdate();
            this.generalCommand.closeOnCompletion();
        }
        catch (SQLException xp) {
            if (this.inTransaction) {
                this.rollBack();
            } else {
                this.closeConnection();
            }
            throw new BaseConcurrencyException(xp.getMessage());
        }
        finally {
            try {
                if (!this.inTransaction) {
                    this.closeConnection();
                } else {
                    this.generalCommand.close();
                }
            }
            catch (SQLException ex1) {
                Logger.getLogger(DataAccess.class.getName()).log(Level.SEVERE, null, ex1);
            }
        }
        if (count == 0 && chkConcurency) {
            throw new BaseConcurrencyException(exception);
        }
        return count;
    }

    private void loadParameters(ParameterValue[] parameters) {
        StringBuilder bld = new StringBuilder();
        try {
            this.generalCommand.clearParameters();
            block22: for (int i = 0; i < parameters.length; ++i) {
                ParameterValue para = parameters[i];
                if (!para.getParameterName().contains("dbClone")) {
                    switch (para.getDataType()) {
                        case BINARY: {
                            this.generalCommand.setBytes(i + 1, this.isNull(JDBCType.BINARY, para.getValue()) ? new byte[]{} : (byte[])para.getValue());
                            break;
                        }
                        case DATE: {
                            this.generalCommand.setDate(i + 1, this.isNull(JDBCType.DATE, para.getValue()) ? new Date(-1L) : (Date)para.getValue());
                            break;
                        }
                        case INTEGER: {
                            this.generalCommand.setInt(i + 1, this.isNull(JDBCType.INTEGER, para.getValue()) ? 0 : (Integer)para.getValue());
                            break;
                        }
                        case VARCHAR: {
                            this.generalCommand.setString(i + 1, this.isNull(JDBCType.VARCHAR, para.getValue()) ? JDBCType.NULL.toString() : (String)para.getValue());
                            break;
                        }
                        case TIMESTAMP: {
                            this.generalCommand.setTimestamp(i + 1, this.isNull(JDBCType.TIMESTAMP, para.getValue()) ? new Timestamp(new java.util.Date().getTime()) : (Timestamp)para.getValue());
                            break;
                        }
                        case CHAR: {
                            this.generalCommand.setString(i + 1, this.isNull(JDBCType.CHAR, para.getValue()) ? JDBCType.NULL.toString() : ((Boolean)para.getValue() == true ? "1" : "0"));
                            break;
                        }
                        case DOUBLE: {
                            this.generalCommand.setDouble(i + 1, this.isNull(JDBCType.DOUBLE, para.getValue()) ? 0.0 : (Double)para.getValue());
                            break;
                        }
                        case FLOAT: {
                            this.generalCommand.setFloat(i + 1, this.isNull(JDBCType.FLOAT, para.getValue()) ? 0.0f : ((Float)para.getValue()).floatValue());
                        }
                    }
                    continue;
                }
                if (this.isNull(para.getDataType(), para.getValue())) continue;
                bld.append(para.toString());
                switch (para.getDataType()) {
                    case BINARY: {
                        this.generalCommand.setBytes(i + 1, this.isNull(JDBCType.BINARY, para.getValue()) ? new byte[]{} : (byte[])para.getValue());
                        continue block22;
                    }
                    case DATE: {
                        this.generalCommand.setDate(i + 1, this.isNull(JDBCType.DATE, para.getValue()) ? new Date(-1L) : (Date)para.getValue());
                        continue block22;
                    }
                    case TIMESTAMP: {
                        this.generalCommand.setTimestamp(i + 1, this.isNull(JDBCType.TIMESTAMP, para.getValue()) ? new Timestamp(new java.util.Date().getTime()) : (Timestamp)para.getValue());
                        continue block22;
                    }
                    case INTEGER: {
                        this.generalCommand.setInt(i + 1, this.isNull(JDBCType.INTEGER, para.getValue()) ? 0 : (Integer)para.getValue());
                        continue block22;
                    }
                    case VARCHAR: {
                        this.generalCommand.setString(i + 1, this.isNull(JDBCType.VARCHAR, para.getValue()) ? null : (String)para.getValue());
                        continue block22;
                    }
                    case CHAR: {
                        this.generalCommand.setString(i + 1, this.isNull(JDBCType.CHAR, para.getValue()) ? null : ((Boolean)para.getValue() == true ? "1" : "0"));
                        continue block22;
                    }
                    case DOUBLE: {
                        this.generalCommand.setDouble(i + 1, this.isNull(JDBCType.DOUBLE, para.getValue()) ? 0.0 : (Double)para.getValue());
                        continue block22;
                    }
                    case FLOAT: {
                        this.generalCommand.setFloat(i + 1, this.isNull(JDBCType.DOUBLE, para.getValue()) ? 0.0f : ((Float)para.getValue()).floatValue());
                    }
                }
            }
        }
        catch (SQLException e) {
            String string = e.getMessage();
        }
    }

    public void rollBack() {
        try {
            this.dbConnect.rollback();
            if (this.dbConnect.getAutoCommit()) {
                this.dbConnect.setAutoCommit(true);
                this.inTransaction = false;
            }
        }
        catch (Exception ex) {
        }
        finally {
            this.inTransaction = false;
            try {
                this.closeConnection();
            }
            catch (SQLException ex) {
                Logger.getLogger(DataAccess.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public void end() {
        try {
            this.dbConnect.commit();
            this.dbConnect.setAutoCommit(true);
            this.inTransaction = false;
        }
        catch (Exception s) {
            try {
                this.dbConnect.close();
            }
            catch (SQLException ex) {
                Logger.getLogger(DataAccess.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        finally {
            this.inTransaction = false;
            try {
                this.closeConnection();
            }
            catch (SQLException ex) {
                Logger.getLogger(DataAccess.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public Object getNull(String type) {
        if (type != null) {
            switch (type) {
                case "float": 
                case "Float": {
                    return Float.valueOf(0.0f);
                }
                case "double": 
                case "Double": {
                    return 0.0;
                }
                case "byte[]": 
                case "Byte[]": {
                    return new byte[0];
                }
                case "String": 
                case "string": {
                    return null;
                }
                case "Date": {
                    return new Date(-1L);
                }
                case "Int64": 
                case "long": {
                    return 0;
                }
                case "Int16": 
                case "short": {
                    return 0;
                }
                case "Int32": 
                case "int": {
                    return 0;
                }
                case "UInt64": 
                case "ulong": {
                    return 0;
                }
                case "UInt32": 
                case "uint": {
                    return 0;
                }
                case "UInt16": 
                case "ushort": {
                    return 0;
                }
                case "byte": 
                case "sbyte": 
                case "Byte": 
                case "SByte": {
                    return 0;
                }
                case "Boolean": 
                case "boolean": 
                case "bool": 
                case "Bool": {
                    return false;
                }
            }
        }
        return null;
    }

    public boolean isNull(JDBCType type, Object value) {
        switch (type) {
            case BINARY: {
                if (value != null && (value.getClass() != byte[].class || ((byte[])value).length != 0)) break;
                return true;
            }
            case CHAR: {
                return false;
            }
            case DATE: {
                if (value != null) break;
                return true;
            }
            case INTEGER: 
            case DOUBLE: {
                return false;
            }
            case VARCHAR: {
                if (value != null && (value == null || value.toString() != "%%")) break;
                return true;
            }
        }
        return false;
    }

    public void start() {
        try {
            if (this.dbConnect.getAutoCommit()) {
                this.dbConnect.setAutoCommit(false);
                this.inTransaction = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public ParameterValue[] getEmptyParameterValues() {
        return this.eParameters;
    }
}

