/*
 * Decompiled with CFR 0.152.
 */
package com.xputertechnologies.santa;

import com.xputertechnologies.santa.Customer;
import com.xputertechnologies.santa.DbEntity;
import com.xputertechnologies.santa.core.BaseConcurrencyException;
import com.xputertechnologies.santa.core.ConsequentialConcurrencyException;
import com.xputertechnologies.santa.core.DataAccess;
import com.xputertechnologies.santa.core.ObjectState;
import com.xputertechnologies.santa.core.ParameterValue;
import com.xputertechnologies.santa.core.Searchable;
import java.sql.JDBCType;
import java.sql.Timestamp;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;

public class SyncSetting
extends DbEntity {
    public SyncSetting vClone;
    private boolean isCloned;
    DataAccess dt = this.getDbAccess();
    private BooleanProperty isChecked = new SimpleBooleanProperty();
    private StringProperty d365URL = new SimpleStringProperty();
    private StringProperty beURL = new SimpleStringProperty();
    private IntegerProperty syncInterval = new SimpleIntegerProperty(1);
    private ObjectProperty<Timestamp> custDateLastSync = new SimpleObjectProperty((Object)new Timestamp(new Date().getTime()));
    private ObjectProperty<Timestamp> custDateLastRead = new SimpleObjectProperty((Object)new Timestamp(new Date().getTime()));
    private ObjectProperty<Timestamp> prodDateLastRead = new SimpleObjectProperty((Object)new Timestamp(new Date().getTime()));
    private ObjectProperty<Timestamp> saleDateLastSync = new SimpleObjectProperty((Object)new Timestamp(new Date().getTime()));
    private ObjectProperty<Timestamp> transferLastDateRead = new SimpleObjectProperty((Object)new Timestamp(new Date().getTime()));

    public SyncSetting(String d365URL, String beURL, int syncInterval, Timestamp custDateLastSync, Timestamp custDateLastRead, Timestamp saleDateLastSync, Timestamp prodDateLastRead, Timestamp transferLastDateRead, DataAccess dbAccess) {
        super(dbAccess);
        this.transferLastDateRead.set((Object)transferLastDateRead);
        this.d365URLProperty().set((Object)d365URL);
        this.beURLProperty().set((Object)beURL);
        this.syncIntervalProperty().set(syncInterval);
        this.custDateLastSyncProperty().set((Object)custDateLastSync);
        this.custDateLastReadProperty().set((Object)custDateLastRead);
        this.saleDateLastSyncProperty().set((Object)saleDateLastSync);
        this.prodDateLastReadProperty().set((Object)prodDateLastRead);
        this.setState(ObjectState.Unchanged);
        this.setMustClone(true);
        this.initializeListener();
    }

    public SyncSetting(DataAccess dt) {
        super(dt);
    }

    public boolean getIsChecked() {
        return this.isChecked.get();
    }

    public void setIsChecked(boolean isChecked) {
        this.isChecked.set(isChecked);
    }

    public BooleanProperty isCheckedProperty() {
        return this.isChecked;
    }

    public StringProperty d365URLProperty() {
        return this.d365URL;
    }

    public String getD365URL() {
        return (String)this.d365URL.get();
    }

    public void setD365URL(String d365Url) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.clone();
        }
        this.changeObjectState();
        this.d365URL.set((Object)d365Url);
    }

    public StringProperty beURLProperty() {
        return this.beURL;
    }

    public String getBEURL() {
        return (String)this.beURL.get();
    }

    public void setBEURL(String endPoint) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.clone();
        }
        this.changeObjectState();
        this.beURL.set((Object)endPoint);
    }

    public IntegerProperty syncIntervalProperty() {
        return this.syncInterval;
    }

    public int getSyncInterval() {
        return this.syncInterval.get();
    }

    public void setSyncInterval(int syncInterval) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.clone();
        }
        this.changeObjectState();
        this.syncInterval.set(syncInterval);
    }

    public Date getCustDateLastSync() {
        return (Date)this.custDateLastSync.get();
    }

    public void setCustDateLastSync(Timestamp dateLastSync) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.clone();
        }
        this.changeObjectState();
        this.custDateLastSync.set((Object)dateLastSync);
    }

    public ObjectProperty<Timestamp> custDateLastSyncProperty() {
        return this.custDateLastSync;
    }

    public Date getCustDateLastRead() {
        return (Date)this.custDateLastRead.get();
    }

    public void setCustDateLastRead(Timestamp custDateLastRead) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.clone();
        }
        this.changeObjectState();
        this.custDateLastRead.set((Object)custDateLastRead);
    }

    public ObjectProperty<Timestamp> custDateLastReadProperty() {
        return this.custDateLastRead;
    }

    public Date getProdDateLastRead() {
        return (Date)this.prodDateLastRead.get();
    }

    public void setProdDateLastRead(Timestamp prodDateLastRead) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.clone();
        }
        this.changeObjectState();
        this.prodDateLastRead.set((Object)prodDateLastRead);
    }

    public ObjectProperty<Timestamp> prodDateLastReadProperty() {
        return this.prodDateLastRead;
    }

    public Date getSaleDateLastSync() {
        return (Date)this.saleDateLastSync.get();
    }

    public void setSaleDateLastSync(Timestamp saleDateLastSync) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.clone();
        }
        this.changeObjectState();
        this.saleDateLastSync.set((Object)saleDateLastSync);
    }

    public ObjectProperty<Timestamp> saleDateLastSyncProperty() {
        return this.saleDateLastSync;
    }

    public Date getTransferLastDateRead() {
        return (Date)this.transferLastDateRead.get();
    }

    public void setTransferLastDateRead(Timestamp transferLastDateRead) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.clone();
        }
        this.changeObjectState();
        this.transferLastDateRead.set((Object)transferLastDateRead);
    }

    public ObjectProperty<Timestamp> saleTransferLastDateReadProperty() {
        return this.transferLastDateRead;
    }

    public SyncSetting clone() {
        SyncSetting syncSetting = new SyncSetting(this.dt);
        this.setMustClone(false);
        syncSetting.syncInterval.set(this.syncInterval.get());
        syncSetting.beURL.set((Object)((String)this.beURL.get()));
        syncSetting.custDateLastSync.set((Object)((Timestamp)this.custDateLastSync.get()));
        syncSetting.custDateLastRead.set((Object)((Timestamp)this.custDateLastRead.get()));
        syncSetting.saleDateLastSync.set((Object)((Timestamp)this.saleDateLastSync.get()));
        syncSetting.prodDateLastRead.set((Object)((Timestamp)this.prodDateLastRead.get()));
        syncSetting.transferLastDateRead.set((Object)((Timestamp)this.transferLastDateRead.get()));
        syncSetting.d365URL.set((Object)((String)this.d365URL.get()));
        this.isCloned = true;
        this.setMustClone(true);
        return syncSetting;
    }

    protected void rollBack() {
        this.beURL.set((Object)((String)this.vClone.beURL.get()));
        this.syncInterval.set(this.vClone.syncInterval.get());
        this.custDateLastSync.set((Object)((Timestamp)this.vClone.custDateLastSync.get()));
        this.custDateLastRead.set((Object)((Timestamp)this.vClone.custDateLastRead.get()));
        this.saleDateLastSync.set((Object)((Timestamp)this.vClone.saleDateLastSync.get()));
        this.prodDateLastRead.set((Object)((Timestamp)this.vClone.prodDateLastRead.get()));
        this.d365URL.set((Object)((String)this.vClone.d365URL.get()));
        this.transferLastDateRead.set((Object)((Timestamp)this.vClone.transferLastDateRead.get()));
        this.isCloned = false;
        this.setMustClone(true);
    }

    @Override
    public void insert() throws Exception {
        try {
            String query = "INSERT INTO SyncSetting(ERPENDPOINT,endPoint,syncInterval,custDateLastSync,custDateLastRead,saleDateLastSync,prodDateLastRead,transferLastDateRead) Values(?,?,?,?,?,?,?,?)";
            ParameterValue[] parameterValues = new ParameterValue[]{new ParameterValue("ERPENDPOINT", JDBCType.VARCHAR, this.d365URL.get()), new ParameterValue("endPoint", JDBCType.VARCHAR, this.beURL.get()), new ParameterValue("syncInterval", JDBCType.INTEGER, this.syncInterval.get()), new ParameterValue("custDateLastSync", JDBCType.TIMESTAMP, this.custDateLastSync.get()), new ParameterValue("custDateLastRead", JDBCType.TIMESTAMP, this.custDateLastRead.get()), new ParameterValue("saleDateLastSync", JDBCType.TIMESTAMP, ((Timestamp)this.saleDateLastSync.get()).getTime()), new ParameterValue("prodDateLastRead", JDBCType.TIMESTAMP, this.prodDateLastRead.get()), new ParameterValue("transferLastDateRead", JDBCType.TIMESTAMP, this.transferLastDateRead.get())};
            this.getDbAccess().performDbOperation(query, parameterValues);
            this.vClone = this.clone();
        }
        catch (Exception e) {
            this.rollBack();
            this.isCloned = false;
            throw e;
        }
    }

    @Override
    public void update() throws Exception {
        try {
            String query = "UPDATE SyncSetting SET ERPENDPOINT=?, endPoint=?,syncInterval=?, custDateLastSync=?,custDateLastRead=?,saleDateLastSync=?,prodDateLastRead=?, transferLastDateRead=? WHERE endPoint=?";
            ParameterValue[] parameterValues = new ParameterValue[]{new ParameterValue("ERPENDPOINT", JDBCType.VARCHAR, this.d365URL.get()), new ParameterValue("endPoint", JDBCType.VARCHAR, this.beURL.get()), new ParameterValue("syncInterval", JDBCType.INTEGER, this.syncInterval.get()), new ParameterValue("custDateLastSync", JDBCType.TIMESTAMP, this.custDateLastSync.get()), new ParameterValue("custDateLastRead", JDBCType.TIMESTAMP, this.custDateLastRead.get()), new ParameterValue("saleDateLastSync", JDBCType.TIMESTAMP, this.saleDateLastSync.get()), new ParameterValue("prodDateLastRead", JDBCType.TIMESTAMP, this.prodDateLastRead.get()), new ParameterValue("transferLastDateRead", JDBCType.TIMESTAMP, this.transferLastDateRead.get()), new ParameterValue("endPoint", JDBCType.VARCHAR, this.vClone.beURL.get())};
            this.getDbAccess().performDbOperation(query, parameterValues, true);
            this.vClone = this.clone();
        }
        catch (Exception e) {
            if (e instanceof BaseConcurrencyException) {
                String message = e.getMessage();
                throw new ConsequentialConcurrencyException(message, (Object)null);
            }
            throw e;
        }
    }

    @Override
    public void delete() {
        String query = "DELETE FROM SyncSetting WHERE endPoint=?";
        ParameterValue[] parameterValues = new ParameterValue[]{new ParameterValue("endPoint", JDBCType.VARCHAR, this.beURL.get())};
        try {
            this.getDbAccess().performDbOperation(query, parameterValues);
        }
        catch (Exception ex) {
            Logger.getLogger(Customer.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public void setDbAccess(DataAccess db) {
        this.dt = db;
    }

    @Override
    public void beforeInsert() {
    }

    @Override
    public void afterInsert() {
    }

    @Override
    public void beforeUpdate() {
    }

    @Override
    public void afterUpdate() {
    }

    @Override
    public Searchable getSearchable() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void initializeListener() {
    }
}

