/*
 * Decompiled with CFR 0.152.
 */
package com.xputertechnologies.santa;

import com.xputertechnologies.santa.Company;
import com.xputertechnologies.santa.DbEntity;
import com.xputertechnologies.santa.core.BaseConcurrencyException;
import com.xputertechnologies.santa.core.DataAccess;
import com.xputertechnologies.santa.core.ObjectState;
import com.xputertechnologies.santa.core.ParameterValue;
import com.xputertechnologies.santa.core.SearchCondition;
import com.xputertechnologies.santa.core.Searchable;
import com.xputertechnologies.santa.list.CompanyDataList;
import com.xputertechnologies.santa.list.StockItemList;
import java.sql.Date;
import java.sql.JDBCType;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.FloatProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleFloatProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;

public class StockItemB2B
extends DbEntity {
    private StringProperty storeName = new SimpleStringProperty("");
    public static String insertQuery = "insert into StockItemB2B  (itemCode,companyName,costPrice,make,name,quantity,price,size,netWeight,syncFlag,isActive,lastSyncDate,storeName) values(?,?,?,?,?,?,?,?,?,?,?,?,?)";
    public static String updateQuery = "update StockItemB2B set itemCode=?,companyName=?,costPrice=?,make=?,name=?,quantity=?,price=?,size=?,netWeight=?,syncFlag=?,isActive=?,lastSyncDate=?,storeName=? where ItemCode=?";
    public boolean isEdit = false;
    private Company parentCompany;
    private FloatProperty netWeight = new SimpleFloatProperty();
    private BooleanProperty syncFlag = new SimpleBooleanProperty(true);
    private StringProperty make = new SimpleStringProperty();
    private int sn;
    private DoubleProperty price = new SimpleDoubleProperty();
    private BooleanProperty isActive = new SimpleBooleanProperty();
    private StringProperty name = new SimpleStringProperty();
    private StringProperty itemCode = new SimpleStringProperty();
    boolean isclone;
    public StockItemB2B vclone;
    private StringProperty tempCode = new SimpleStringProperty(UUID.randomUUID().toString());
    private StringProperty size = new SimpleStringProperty();
    private ObjectProperty lastSyncDate = new SimpleObjectProperty((Object)Date.valueOf(LocalDate.now()));
    private DoubleProperty costPrice = new SimpleDoubleProperty();
    private FloatProperty quantity = new SimpleFloatProperty();
    private StringProperty companyName = new SimpleStringProperty("");

    public StringProperty storeNameProperty() {
        return this.storeName;
    }

    public String getStoreName() {
        return (String)this.storeName.get();
    }

    public void setStoreName(String storeName) {
        this.storeName.set((Object)storeName);
    }

    public int getSn() {
        return this.sn;
    }

    public void setSn(int sn) {
        this.sn = sn;
    }

    public StockItemB2B() {
    }

    public StockItemB2B(DataAccess dbAccess) {
        super(dbAccess);
    }

    public float getNetWeight() {
        return this.netWeight.get();
    }

    public void setNetWeight(float netWeight) {
        if (!this.isclone && this.isMustClone()) {
            this.vclone = this.clone();
        }
        this.netWeight.set(netWeight);
        this.changeObjectState();
    }

    public FloatProperty netWeightProperty() {
        return this.netWeight;
    }

    public Boolean getSyncFlag() {
        return this.syncFlag.get();
    }

    public void setSyncFlag(Boolean syncFlag) {
        if (!this.isclone && this.isMustClone()) {
            this.vclone = this.clone();
        }
        this.syncFlag.set(syncFlag.booleanValue());
        this.changeObjectState();
    }

    public BooleanProperty syncFlagProperty() {
        return this.syncFlag;
    }

    public StockItemB2B(String itemCode, String companyName, Double costPrice, String make, String name, String size, Date lastSyncDate, Float qty, Float netWeight, Double price, Boolean isActive, Boolean syncFlag, String storeName, DataAccess dt) {
        super(dt);
        this.netWeight.set(netWeight.floatValue());
        this.itemCode.set((Object)itemCode);
        this.name.set((Object)name);
        this.make.set((Object)make);
        this.size.set((Object)size);
        this.storeName.set((Object)storeName);
        this.costPrice.set(costPrice.doubleValue());
        this.quantity.set(qty.floatValue());
        this.companyName.set((Object)companyName);
        this.price.set(price.doubleValue());
        this.isActive.set(isActive.booleanValue());
        this.syncFlag.set(syncFlag.booleanValue());
        this.lastSyncDate.set((Object)lastSyncDate);
        this.setState(ObjectState.Unchanged);
        this.setMustClone(true);
        this.initializeListener();
        this.vclone = this.clone();
    }

    public boolean existInStockItem() {
        StockItemList stockItemList = new StockItemList(this.getParentCompany().getDbAccess());
        stockItemList.selectAll("Select * From StockItemB2B where name=? and make=? and size=?", new ParameterValue[]{new ParameterValue("name", JDBCType.VARCHAR, this.name.get()), new ParameterValue("maker", JDBCType.VARCHAR, this.make.get()), new ParameterValue("size", JDBCType.VARCHAR, this.size.get())});
        return stockItemList.getOriginalList().size() == 1;
    }

    public StringProperty makerProperty() {
        return this.make;
    }

    public String getMake() {
        return (String)this.make.get();
    }

    public void setMake(String maker) {
        if (!this.isclone && this.isMustClone()) {
            this.vclone = this.clone();
        }
        this.make.set((Object)maker);
        this.changeObjectState();
    }

    public double getPrice() {
        return this.price.get();
    }

    public void setPrice(double price) {
        if (!this.isclone && this.isMustClone()) {
            this.vclone = this.clone();
        }
        this.price.set(price);
        this.changeObjectState();
    }

    public DoubleProperty priceProperty() {
        return this.price;
    }

    public BooleanProperty isActiveProperty() {
        return this.isActive;
    }

    public boolean getIsActive() {
        return this.isActive.get();
    }

    public void setIsActive(boolean isActive) {
        if (!this.isclone && this.isMustClone()) {
            this.vclone = this.clone();
        }
        this.isActive.set(isActive);
        this.changeObjectState();
    }

    public StringProperty nameProperty() {
        return this.name;
    }

    public String getName() {
        return (String)this.name.get();
    }

    public void setName(String name) {
        if (!this.isclone && this.isMustClone()) {
            this.vclone = this.clone();
        }
        this.name.set((Object)name);
        this.changeObjectState();
    }

    public StringProperty itemCodeProperty() {
        return this.itemCode;
    }

    public String getItemCode() {
        return (String)this.itemCode.get();
    }

    public void setItemCode(String itemCode) {
        if (!this.isclone && this.isMustClone()) {
            this.vclone = this.clone();
        }
        this.itemCode.set((Object)itemCode);
        this.changeObjectState();
    }

    public StringProperty tempCodeProperty() {
        return this.tempCode;
    }

    public String getSize() {
        return (String)this.size.get();
    }

    public void setSize(String size) {
        if (!this.isclone && this.isMustClone()) {
            this.vclone = this.clone();
        }
        this.size.set((Object)size);
        this.changeObjectState();
    }

    public StringProperty sizeProperty() {
        return this.size;
    }

    public Date getLastSyncDate() {
        return (Date)this.lastSyncDate.get();
    }

    public void setLastSyncDate(Date LastSyncDate) {
        if (!this.isclone && this.isMustClone()) {
            this.vclone = this.clone();
        }
        this.lastSyncDate.set((Object)LastSyncDate);
        this.changeObjectState();
    }

    public ObjectProperty lastSyncDateProperty() {
        return this.lastSyncDate;
    }

    public double getCostPrice() {
        return this.costPrice.get();
    }

    public void setCostPrice(double costPrice) {
        if (!this.isclone && this.isMustClone()) {
            this.vclone = this.clone();
        }
        this.costPrice.set(costPrice);
        this.changeObjectState();
    }

    public DoubleProperty costPriceProperty() {
        return this.costPrice;
    }

    public float getQuantity() {
        return this.quantity.get();
    }

    public void setQuantity(float quantity) {
        if (!this.isclone && this.isMustClone() && this.vclone == null) {
            this.vclone = this.clone();
        }
        this.quantity.set(quantity);
        this.changeObjectState();
    }

    public FloatProperty quantityProperty() {
        return this.quantity;
    }

    public String getCompanyName() {
        return (String)this.companyName.get();
    }

    public StringProperty companyNameProperty() {
        return this.companyName;
    }

    public void setcompanyName(String companyName) {
        if (!this.isclone && this.isMustClone()) {
            this.vclone = this.clone();
        }
        this.companyName.set((Object)companyName);
        this.changeObjectState();
    }

    public static ArrayList<String> searchStockItem(String searchString, DataAccess dt) {
        ArrayList<ParameterValue> tempParamValue = new ArrayList<ParameterValue>();
        ArrayList<String> result = new ArrayList<String>();
        StockItemList stockItemList = new StockItemList(dt);
        tempParamValue.add(new ParameterValue("itemCode", JDBCType.VARCHAR, "%" + searchString + "%"));
        tempParamValue.add(new ParameterValue("companyName", JDBCType.VARCHAR, "%" + searchString + "%"));
        tempParamValue.add(new ParameterValue("make", JDBCType.VARCHAR, "%" + searchString + "%"));
        tempParamValue.add(new ParameterValue("name", JDBCType.VARCHAR, "%" + searchString + "%"));
        tempParamValue.add(new ParameterValue("size", JDBCType.VARCHAR, "%" + searchString + "%"));
        SearchCondition searchCondition = new SearchCondition();
        searchCondition.setParametersvalues(tempParamValue);
        if (!searchString.equals("") && searchString != null) {
            stockItemList.select(searchCondition, true, false);
        }
        return result;
    }

    public static StockItemList searchStock(String searchString, DataAccess dt) {
        ArrayList<ParameterValue> tempParamValue = new ArrayList<ParameterValue>();
        StockItemList stockItemList = new StockItemList(dt);
        tempParamValue.add(new ParameterValue("companyName", JDBCType.VARCHAR, "%" + searchString + "%"));
        tempParamValue.add(new ParameterValue("name", JDBCType.VARCHAR, "%" + searchString + "%"));
        tempParamValue.add(new ParameterValue("itemCode", JDBCType.VARCHAR, "%" + searchString + "%"));
        tempParamValue.add(new ParameterValue("type", JDBCType.VARCHAR, "%" + searchString + "%"));
        SearchCondition searchCondition = new SearchCondition();
        searchCondition.setParametersvalues(tempParamValue);
        if (!searchString.equals("") && searchString != null) {
            stockItemList.select(searchCondition, true, false);
        } else {
            stockItemList.selectAll("Select * From StockItem", dt.getEmptyParameterValues());
        }
        return stockItemList;
    }

    @Override
    public void insert() throws Exception {
        try {
            ParameterValue[] paramValue = new ParameterValue[]{new ParameterValue("itemCode", JDBCType.VARCHAR, this.itemCode.get()), new ParameterValue("companyName", JDBCType.VARCHAR, this.parentCompany.getName()), new ParameterValue("costPrice", JDBCType.DOUBLE, this.costPrice.get()), new ParameterValue("make", JDBCType.VARCHAR, this.make.get()), new ParameterValue("name", JDBCType.VARCHAR, this.name.get()), new ParameterValue("quantity", JDBCType.FLOAT, Float.valueOf(this.quantity.get())), new ParameterValue("price", JDBCType.DOUBLE, this.price.get()), new ParameterValue("size", JDBCType.VARCHAR, this.size.get()), new ParameterValue("netWeight", JDBCType.FLOAT, Float.valueOf(this.netWeight.get())), new ParameterValue("syncFlag", JDBCType.CHAR, this.syncFlag.get()), new ParameterValue("isActive", JDBCType.CHAR, this.isActive.get()), new ParameterValue("lastSyncDate", JDBCType.DATE, this.lastSyncDate.get()), new ParameterValue("storeName", JDBCType.VARCHAR, this.storeName.get())};
            this.getDbAccess().performDbOperation(insertQuery, paramValue);
            this.vclone = this.clone();
        }
        catch (Exception ex) {
            this.rollBack();
            this.isclone = false;
            throw ex;
        }
    }

    public static void deleteAll(DataAccess dt) {
        String query = "Delete from StockItemB2B";
        try {
            dt.performDbOperation(query, dt.getEmptyParameterValues());
        }
        catch (Exception ex) {
            Logger.getLogger(StockItemB2B.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public void update() throws BaseConcurrencyException, Exception {
        try {
            ParameterValue[] paramValue = new ParameterValue[]{new ParameterValue("itemCode", JDBCType.VARCHAR, this.itemCode.get()), new ParameterValue("companyName", JDBCType.VARCHAR, this.parentCompany.getName()), new ParameterValue("costPrice", JDBCType.DOUBLE, this.costPrice.get()), new ParameterValue("make", JDBCType.VARCHAR, this.make.get()), new ParameterValue("name", JDBCType.VARCHAR, this.name.get()), new ParameterValue("quantity", JDBCType.FLOAT, Float.valueOf(this.quantity.get())), new ParameterValue("price", JDBCType.DOUBLE, this.price.get()), new ParameterValue("size", JDBCType.VARCHAR, this.size.get()), new ParameterValue("netWeight", JDBCType.FLOAT, Float.valueOf(this.netWeight.get())), new ParameterValue("syncFlag", JDBCType.CHAR, this.syncFlag.get()), new ParameterValue("isActive", JDBCType.CHAR, this.isActive.get()), new ParameterValue("lastSyncDate", JDBCType.DATE, this.lastSyncDate.get()), new ParameterValue("storeName", JDBCType.VARCHAR, this.storeName.get()), new ParameterValue("cloneItemCode", JDBCType.VARCHAR, this.vclone.itemCode.get())};
            this.getDbAccess().performDbOperation(updateQuery, paramValue, true);
            this.vclone = this.clone();
        }
        catch (Exception ex) {
            this.rollBack();
            this.isclone = false;
            if (ex instanceof BaseConcurrencyException) {
                throw new BaseConcurrencyException("This object has been modified by another user, please reload your data", null);
            }
            throw ex;
        }
    }

    @Override
    public void delete() {
        String query = "Delete from \"StockItemB2B\" where itemCode=? ";
        try {
            this.getDbAccess().performDbOperation(query, new ParameterValue[]{new ParameterValue("itemCode", JDBCType.VARCHAR, this.itemCode.get())});
        }
        catch (Exception ex) {
            Logger.getLogger(StockItemB2B.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public Searchable getSearchable() {
        Searchable sb = new Searchable();
        sb.setTableName("StockItem");
        String[] parameters = new String[]{"itemCode", "companyName", "make", "name", "size"};
        sb.setParameters(parameters);
        return sb;
    }

    public StockItemB2B clone() {
        StockItemB2B cloneTemp = new StockItemB2B(this.getDbAccess());
        cloneTemp.setMustClone(false);
        cloneTemp.itemCode.set((Object)((String)this.itemCode.get()));
        cloneTemp.netWeight.set(this.netWeight.get());
        cloneTemp.name.set((Object)((String)this.name.get()));
        cloneTemp.make.set((Object)((String)this.make.get()));
        cloneTemp.size.set((Object)((String)this.size.get()));
        cloneTemp.price.set(this.price.get());
        cloneTemp.costPrice.set(this.costPrice.get());
        cloneTemp.quantity.set(this.quantity.get());
        cloneTemp.lastSyncDate.set(this.lastSyncDate.get());
        cloneTemp.storeName.set((Object)((String)this.storeName.get()));
        cloneTemp.syncFlag.set(this.syncFlag.get());
        cloneTemp.isActive.set(this.isActive.get());
        cloneTemp.companyName = this.companyName;
        cloneTemp.setMustClone(true);
        this.isclone = true;
        return cloneTemp;
    }

    private void rollBack() {
        this.itemCode = this.vclone.itemCode;
        this.name = this.vclone.name;
        this.storeName = this.vclone.storeName;
        this.netWeight = this.vclone.netWeight;
        this.make = this.vclone.make;
        this.size = this.vclone.size;
        this.price = this.vclone.price;
        this.costPrice = this.vclone.costPrice;
        this.quantity = this.vclone.quantity;
        this.lastSyncDate = this.vclone.lastSyncDate;
        this.syncFlag = this.vclone.syncFlag;
        this.isActive = this.vclone.isActive;
        this.companyName = this.vclone.companyName;
        this.setMustClone(true);
    }

    public void setParentCompany(Company cp) {
        this.parentCompany = cp;
        this.companyName.set((Object)(cp == null ? "" : cp.getName()));
        this.changeObjectState();
    }

    public void loadParentCompany() {
        CompanyDataList compList = new CompanyDataList(this.getDbAccess());
        ParameterValue[] paramValue = new ParameterValue[]{new ParameterValue("name", JDBCType.VARCHAR, this.companyName)};
        String query = "Select * From Company where name=?";
        compList.selectAll(query, paramValue);
        if (compList.getOriginalList().size() > 0) {
            this.parentCompany = (Company)compList.getOriginalList().get(0);
        }
    }

    public Company getParentCompany() {
        if (this.parentCompany == null) {
            this.loadParentCompany();
        }
        return this.parentCompany;
    }

    @Override
    public void beforeInsert() {
    }

    @Override
    public void afterInsert() {
        this.setState(ObjectState.Unchanged);
    }

    @Override
    public void beforeUpdate() {
    }

    @Override
    public void afterUpdate() {
        this.setState(ObjectState.Unchanged);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        StockItemB2B stockItem = (StockItemB2B)object;
        if (stockItem.itemCode.get() == null || this.itemCode.get() == null) {
            return false;
        }
        return ((String)this.itemCode.get()).equals(stockItem.itemCode.get());
    }

    @Override
    public void initializeListener() {
        this.make.addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                StockItemB2B.this.setMake(newValue);
            }
        });
        this.name.addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                StockItemB2B.this.setName(newValue);
            }
        });
        this.storeName.addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                StockItemB2B.this.setStoreName(newValue);
            }
        });
        this.size.addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                StockItemB2B.this.setSize(newValue);
            }
        });
        this.price.addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                StockItemB2B.this.setPrice((Double)newValue);
            }
        });
        this.costPrice.addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                StockItemB2B.this.setCostPrice((Double)newValue);
            }
        });
        this.quantity.addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                StockItemB2B.this.setQuantity(((Float)newValue).floatValue());
            }
        });
        this.storeName.addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                StockItemB2B.this.setStoreName(newValue);
            }
        });
    }
}

