/*
 * Decompiled with CFR 0.152.
 */
package com.xputertechnologies.santa;

import com.xputertechnologies.santa.Company;
import com.xputertechnologies.santa.DbEntity;
import com.xputertechnologies.santa.core.BaseConcurrencyException;
import com.xputertechnologies.santa.core.ConsequentialConcurrencyException;
import com.xputertechnologies.santa.core.DataAccess;
import com.xputertechnologies.santa.core.ObjectState;
import com.xputertechnologies.santa.core.ParameterValue;
import com.xputertechnologies.santa.core.Searchable;
import java.sql.Date;
import java.sql.JDBCType;
import java.time.LocalDate;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;

public class ReportSync
extends DbEntity {
    private boolean isCloned;
    public ReportSync vClone;
    private BooleanProperty isSent = new SimpleBooleanProperty();
    private ObjectProperty<Date> currentDay = new SimpleObjectProperty((Object)Date.valueOf(LocalDate.now()));

    public ReportSync(Date currentDay, boolean isSent, DataAccess dbAccess) {
        super(dbAccess);
        this.isSent.set(isSent);
        this.currentDay.set((Object)currentDay);
        this.setState(ObjectState.Unchanged);
        this.setMustClone(true);
        this.initializeListener();
        this.vClone = this.clone();
    }

    public ReportSync(DataAccess dbAccess) {
        super(dbAccess);
    }

    public boolean getIsSent() {
        return this.isSent.get();
    }

    public Date getCurrentDay() {
        return (Date)this.currentDay.get();
    }

    public ObjectProperty<Date> currentDayProperty() {
        return this.currentDay;
    }

    public void setCurrentDay(Date date) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.clone();
        }
        this.changeObjectState();
        this.currentDay.set((Object)date);
    }

    public void setIsSent(boolean isSent) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.clone();
        }
        this.isSent.set(isSent);
        this.changeObjectState();
    }

    public BooleanProperty isSentProperty() {
        return this.isSent;
    }

    protected void rollBack() {
        this.isSent.set(this.vClone.isSent.get());
        this.currentDay.set((Object)((Date)this.vClone.currentDay.get()));
        this.setMustClone(true);
    }

    public ReportSync() {
    }

    public ReportSync clone() {
        ReportSync reportSync = new ReportSync();
        reportSync.setMustClone(false);
        reportSync.isSent.set(this.isSent.get());
        reportSync.currentDay.set((Object)((Date)this.currentDay.get()));
        this.setMustClone(true);
        this.isCloned = true;
        return reportSync;
    }

    @Override
    public void insert() throws Exception {
        try {
            String query = "INSERT INTO ReportSync(isSent,currentDay)  Values(?,?)";
            ParameterValue[] parameterValues = new ParameterValue[]{new ParameterValue("isSent", JDBCType.CHAR, this.isSent.get()), new ParameterValue("currentDay", JDBCType.DATE, this.currentDay.get())};
            this.getDbAccess().performDbOperation(query, parameterValues);
            this.vClone = this.clone();
        }
        catch (Exception e) {
            this.rollBack();
            this.isCloned = false;
            try {
                throw e;
            }
            catch (Exception ex) {
                Logger.getLogger(Company.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    @Override
    public void update() throws Exception {
        try {
            String query = "UPDATE ReportSync SET isSent=?, currentDay=? WHERE currentDay=?";
            ParameterValue[] parameterValues = new ParameterValue[]{new ParameterValue("isSent", JDBCType.CHAR, this.isSent.get()), new ParameterValue("currentDay", JDBCType.DATE, this.currentDay.get()), new ParameterValue("clonecurrentDay", JDBCType.DATE, this.vClone.currentDay.get())};
            this.getDbAccess().performDbOperation(query, parameterValues, true);
            this.vClone = this.clone();
        }
        catch (Exception e) {
            if (e instanceof BaseConcurrencyException) {
                String message = e.getMessage();
                throw new ConsequentialConcurrencyException(message, (Object)null);
            }
            throw e;
        }
    }

    @Override
    public void delete() throws Exception {
        try {
            String query = "DELETE FROM ReportSync WHERE currentDay=?";
            ParameterValue[] parameterValues = new ParameterValue[]{new ParameterValue("currentDay", JDBCType.DATE, this.currentDay)};
            this.getDbAccess().performDbOperation(query, parameterValues);
        }
        catch (Exception ex) {
            Logger.getLogger(Company.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public void beforeInsert() {
    }

    @Override
    public void afterInsert() {
        this.setState(ObjectState.Unchanged);
    }

    @Override
    public void beforeUpdate() {
    }

    @Override
    public void afterUpdate() {
        this.setState(ObjectState.Unchanged);
    }

    public void setIsCloned(boolean isCloned) {
        this.isCloned = isCloned;
    }

    @Override
    public Searchable getSearchable() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void initializeListener() {
    }
}

