/*
 * Decompiled with CFR 0.152.
 */
package com.xputertechnologies.santa;

import com.xputertechnologies.santa.Customer;
import com.xputertechnologies.santa.DbEntity;
import com.xputertechnologies.santa.IPurchase;
import com.xputertechnologies.santa.POApprovalHistory;
import com.xputertechnologies.santa.PurchaseDeliveryNote;
import com.xputertechnologies.santa.PurchaseInvoice;
import com.xputertechnologies.santa.PurchaseLineItem;
import com.xputertechnologies.santa.core.BaseConcurrencyException;
import com.xputertechnologies.santa.core.ConsequentialConcurrencyException;
import com.xputertechnologies.santa.core.DataAccess;
import com.xputertechnologies.santa.core.ObjectState;
import com.xputertechnologies.santa.core.ParameterValue;
import com.xputertechnologies.santa.core.Searchable;
import com.xputertechnologies.santa.list.PurchaseLineItemDataList;
import java.sql.Date;
import java.sql.JDBCType;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;

public class PurchaseOrder
extends DbEntity
implements IPurchase {
    public int DocEntry;
    public int DockNum;
    public int BaseDocumentNum;
    public String approvingUser;
    public String CurrentEditStage;
    public String CurrentCloseStage;
    public String CurrentCloseStatus;
    public String CurrentEditStatus;
    public double Total = 0.0;
    private ObservableList<POApprovalHistory> histories = FXCollections.observableArrayList();
    private ObservableList<PurchaseOrder> poHistories = FXCollections.observableArrayList();
    public int approvedStatus = 0;
    private ObservableList<PurchaseLineItem> items = FXCollections.observableArrayList();
    private ObservableList<PurchaseDeliveryNote> deleveryNotes = FXCollections.observableArrayList();
    private ObservableList<PurchaseInvoice> invoices = FXCollections.observableArrayList();
    int counter = 0;
    private StringProperty storeName = new SimpleStringProperty("");
    private StringProperty attachmentLink = new SimpleStringProperty("");
    private DoubleProperty taxAmount = new SimpleDoubleProperty(0.0);
    private DoubleProperty totalAmount = new SimpleDoubleProperty(0.0);
    private DoubleProperty dockTotal = new SimpleDoubleProperty(0.0);
    private DoubleProperty total = new SimpleDoubleProperty(0.0);
    private StringProperty syncError = new SimpleStringProperty("");
    private StringProperty createComment = new SimpleStringProperty("");
    private BooleanProperty canEdit = new SimpleBooleanProperty(true);
    private StringProperty OrderNo = new SimpleStringProperty("");
    private StringProperty createdBy = new SimpleStringProperty("");
    private StringProperty approvalComment = new SimpleStringProperty();
    private StringProperty paymentTerm = new SimpleStringProperty("");
    private StringProperty currency = new SimpleStringProperty();
    private StringProperty costCenter = new SimpleStringProperty("");
    private StringProperty status = new SimpleStringProperty();
    private BooleanProperty isSaveForPDN = new SimpleBooleanProperty();
    private BooleanProperty syncFlag = new SimpleBooleanProperty();
    private StringProperty code = new SimpleStringProperty(UUID.randomUUID().toString());
    private StringProperty purchaseType = new SimpleStringProperty();
    private StringProperty currentStage = new SimpleStringProperty();
    private StringProperty editTemplateDescription = new SimpleStringProperty("");
    private StringProperty parentTemplateDescription = new SimpleStringProperty();
    private StringProperty sapCode = new SimpleStringProperty("");
    private StringProperty supplierCode = new SimpleStringProperty("");
    private StringProperty tempStatus = new SimpleStringProperty();
    private StringProperty supplierName = new SimpleStringProperty();
    public java.util.Date dateApproved = new java.util.Date();
    public String remark = "";
    private ObjectProperty<java.util.Date> dateCreated = new SimpleObjectProperty((Object)Date.valueOf(LocalDate.now()));
    private ObjectProperty<java.util.Date> dueDate = new SimpleObjectProperty((Object)Date.valueOf(LocalDate.now()));
    private StringProperty dateCreatedString = new SimpleStringProperty("");
    private StringProperty dueDateString = new SimpleStringProperty("");
    private StringProperty storeCode = new SimpleStringProperty("Isolo");
    public PurchaseOrder vClone;
    private boolean isCloned;
    DataAccess dt = this.getDbAccess();
    private int sn;

    public int getSn() {
        return this.sn;
    }

    public void setSn(int sn) {
        this.sn = sn;
    }

    public ObservableList<POApprovalHistory> getHistories() {
        return this.histories;
    }

    public ObservableList<PurchaseOrder> getPOHistory() {
        return this.poHistories;
    }

    public ObservableList<PurchaseLineItem> getItems() {
        return this.items;
    }

    public ObservableList<PurchaseDeliveryNote> getDeleveryNotes() {
        return this.deleveryNotes;
    }

    public ObservableList<PurchaseInvoice> getInvoces() {
        return this.invoices;
    }

    public void resetNumbering() {
        this.counter = 0;
        this.items.forEach(val -> {
            ++this.counter;
            val.setSn(this.counter);
        });
    }

    public StringProperty storeNameProperty() {
        return this.storeName;
    }

    public StringProperty attachmentLinkProperty() {
        return this.attachmentLink;
    }

    public double getTaxAmount() {
        return this.taxAmount.get();
    }

    public void setTaxAmount(double totalTax) {
        this.taxAmount.set(totalTax);
    }

    public DoubleProperty taxAmountProperty() {
        return this.taxAmount;
    }

    public double getTotalAmount() {
        return this.totalAmount.get();
    }

    public void setTotalAmount(double totalAmount) {
        this.totalAmount.set(totalAmount);
    }

    public DoubleProperty totalAmountProperty() {
        return this.totalAmount;
    }

    public DoubleProperty dockTotalProperty() {
        return this.dockTotal;
    }

    public DoubleProperty totalProperty() {
        return this.total;
    }

    public double getTotal() {
        return this.total.get();
    }

    public void setTotal(double lineTotal) {
        this.total.set(lineTotal);
    }

    public StringProperty syncErrorProperty() {
        return this.syncError;
    }

    public StringProperty createCommentProperty() {
        return this.createComment;
    }

    public BooleanProperty canEditProperty() {
        return this.canEdit;
    }

    public StringProperty OrderNoProperty() {
        return this.OrderNo;
    }

    public StringProperty createdByProperty() {
        return this.createdBy;
    }

    public StringProperty approvalCommentProperty() {
        return this.approvalComment;
    }

    public StringProperty paymentTermProperty() {
        return this.paymentTerm;
    }

    public String getPaymentTerm() {
        return (String)this.paymentTerm.get();
    }

    public void setPaymentTerm(String paymentTerm) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.clone();
        }
        this.paymentTerm.set((Object)paymentTerm);
        this.changeObjectState();
    }

    public String getCreateComment() {
        return (String)this.createComment.get();
    }

    public void setCreateComment(String createComment) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.clone();
        }
        this.createComment.set((Object)createComment);
        this.changeObjectState();
    }

    public String getCurrency() {
        return (String)this.currency.get();
    }

    public void setCurrency(String currency) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.clone();
        }
        this.currency.set((Object)currency);
        this.changeObjectState();
    }

    public String getCostCenter() {
        return (String)this.costCenter.get();
    }

    public StringProperty costCenterProperty() {
        return this.costCenter;
    }

    public void setCostCenter(String costCenter) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.clone();
        }
        this.costCenter.set((Object)costCenter);
        this.changeObjectState();
    }

    public StringProperty currencyProperty() {
        return this.currency;
    }

    public StringProperty statusProperty() {
        return this.status;
    }

    public String getStatus() {
        return (String)this.status.get();
    }

    public void setStatus(String status) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.clone();
        }
        this.changeObjectState();
        this.status.set((Object)status);
    }

    public Boolean getIsSaveForPDN() {
        return this.isSaveForPDN.get();
    }

    public void setIsSaveForPDN(Boolean isSaveForPDN) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.clone();
        }
        this.isSaveForPDN.set(isSaveForPDN.booleanValue());
        this.changeObjectState();
    }

    public BooleanProperty isSaveForPDNProperty() {
        return this.isSaveForPDN;
    }

    public Boolean getSyncFlag() {
        return this.syncFlag.get();
    }

    public void setSyncFlag(Boolean syncFlag) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.clone();
        }
        this.syncFlag.set(syncFlag.booleanValue());
        this.changeObjectState();
    }

    public BooleanProperty syncFlagProperty() {
        return this.syncFlag;
    }

    public StringProperty codeProperty() {
        return this.code;
    }

    public String getCode() {
        return (String)this.code.get();
    }

    public void setCode(String code) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.clone();
        }
        this.changeObjectState();
        this.code.set((Object)code);
    }

    public StringProperty purchaseTypeProperty() {
        return this.purchaseType;
    }

    public String getPurchaseType() {
        return (String)this.purchaseType.get();
    }

    public void setPurchaseType(String purchaseType) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.clone();
        }
        this.changeObjectState();
        this.purchaseType.set((Object)purchaseType);
    }

    public StringProperty currentStageProperty() {
        return this.currentStage;
    }

    public String getCurrentStage() {
        return (String)this.currentStage.get();
    }

    public void setCurrentStage(String currentStage) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.clone();
        }
        this.changeObjectState();
        this.currentStage.set((Object)currentStage);
    }

    public StringProperty editTemplateDescriptionProperty() {
        return this.editTemplateDescription;
    }

    public StringProperty parentTemplateDescriptionProperty() {
        return this.parentTemplateDescription;
    }

    public String getParentTemplateDescription() {
        return (String)this.parentTemplateDescription.get();
    }

    public void setParentTemplateDescription(String parentTemplateDescription) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.clone();
        }
        this.changeObjectState();
        this.parentTemplateDescription.set((Object)parentTemplateDescription);
    }

    public StringProperty sapCodeProperty() {
        return this.sapCode;
    }

    public String getSapCode() {
        return (String)this.sapCode.get();
    }

    public void setSapCode(String sapCode) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.clone();
        }
        this.changeObjectState();
        this.sapCode.set((Object)sapCode);
    }

    public StringProperty supplierCodeProperty() {
        return this.supplierCode;
    }

    public String getSupplierCode() {
        return (String)this.supplierCode.get();
    }

    public void setSupplierCode(String supplierCode) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.clone();
        }
        this.changeObjectState();
        this.supplierCode.set((Object)supplierCode);
    }

    public StringProperty tempStatusProperty() {
        return this.supplierCode;
    }

    public StringProperty supplierNameProperty() {
        return this.supplierName;
    }

    public String getSupplierName() {
        return (String)this.supplierName.get();
    }

    public void setSupplierName(String supplierName) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.clone();
        }
        this.changeObjectState();
        this.supplierName.set((Object)supplierName);
    }

    public java.util.Date getDateCreated() {
        return (java.util.Date)this.dateCreated.get();
    }

    public void setDateCreated(java.util.Date date) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.clone();
        }
        this.changeObjectState();
        this.dateCreated.set((Object)date);
    }

    public ObjectProperty<java.util.Date> dateCreatedProperty() {
        return this.dateCreated;
    }

    public java.util.Date getDueDate() {
        return (java.util.Date)this.dueDate.get();
    }

    public void setDueDate(java.util.Date dueDate) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.clone();
        }
        this.changeObjectState();
        this.dueDate.set((Object)dueDate);
    }

    public ObjectProperty<java.util.Date> dueDateProperty() {
        return this.dueDate;
    }

    public StringProperty dateCreatedStringProperty() {
        return this.dateCreatedString;
    }

    public StringProperty dueDateStringProperty() {
        return this.dueDateString;
    }

    public StringProperty storeCodeProperty() {
        return this.storeCode;
    }

    public String getStoreCode() {
        return (String)this.storeCode.get();
    }

    public void setStoreCode(String storeCode) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.clone();
        }
        this.storeCode.set((Object)storeCode);
        this.changeObjectState();
    }

    public void loadPurchaseItem() {
        PurchaseLineItemDataList poList = new PurchaseLineItemDataList(this.getDbAccess());
        poList.selectAll("Select * From PurchaseLineItem  where parentCode=?", new ParameterValue[]{new ParameterValue("parentCode", JDBCType.VARCHAR, this.code.get())});
        poList.getOriginalList().forEach(t -> t.loadSerials());
        this.items.addAll(poList.getOriginalList());
    }

    public PurchaseOrder(DataAccess dt) {
        super(dt);
        this.initializeListener();
    }

    public PurchaseOrder(String code, String sapCode, String supplierCode, String supplierName, java.util.Date dateCreated, java.util.Date dueDate, String status, Boolean syncFlag, String currentStage, String parentTemplateDescription, String purchaseType, String paymentTerm, String currency, String store, String createComment, boolean isSaveForPDN, String costCenter, DataAccess dbAccess) {
        super(dbAccess);
        this.isSaveForPDN.set(isSaveForPDN);
        this.costCenter.set((Object)costCenter);
        this.createComment.set((Object)createComment);
        this.storeCode.set((Object)store);
        this.currency.set((Object)currency);
        this.paymentTerm.set((Object)paymentTerm);
        this.syncFlag.set(syncFlag.booleanValue());
        this.currentStage.set((Object)currentStage);
        this.parentTemplateDescription.set((Object)parentTemplateDescription);
        this.status.set((Object)status);
        this.code.set((Object)code);
        this.sapCode.set((Object)sapCode);
        this.supplierCode.set((Object)supplierCode);
        this.supplierName.set((Object)supplierName);
        this.dateCreated.set((Object)dateCreated);
        this.dueDate.set((Object)dueDate);
        this.purchaseType.set((Object)purchaseType);
        this.setState(ObjectState.Unchanged);
        this.setMustClone(true);
        this.initializeListener();
    }

    public PurchaseOrder clone() {
        PurchaseOrder porder = new PurchaseOrder(this.dt);
        porder.setMustClone(false);
        porder.isSaveForPDN.set(this.isSaveForPDN.get());
        porder.createComment.set((Object)((String)this.createComment.get()));
        porder.storeCode.set((Object)((String)this.storeCode.get()));
        porder.currency.set((Object)((String)this.currency.get()));
        porder.paymentTerm.set((Object)((String)this.paymentTerm.get()));
        porder.purchaseType.set((Object)((String)this.purchaseType.get()));
        porder.code.set((Object)((String)this.code.get()));
        porder.sapCode.set((Object)((String)this.sapCode.get()));
        porder.supplierCode.set((Object)((String)this.supplierCode.get()));
        porder.supplierName.set((Object)((String)this.supplierName.get()));
        porder.dateCreated.set((Object)((java.util.Date)this.dateCreated.get()));
        porder.dueDate.set((Object)((java.util.Date)this.dueDate.get()));
        porder.status.set((Object)((String)this.status.get()));
        porder.syncFlag.set(this.syncFlag.get());
        porder.costCenter.set((Object)((String)this.costCenter.get()));
        porder.currentStage.set((Object)((String)this.currentStage.get()));
        porder.parentTemplateDescription.set((Object)((String)this.parentTemplateDescription.get()));
        this.setMustClone(true);
        this.isCloned = true;
        return porder;
    }

    protected void rollBack() {
        this.isSaveForPDN.set(this.vClone.isSaveForPDN.get());
        this.createComment.set((Object)((String)this.vClone.createComment.get()));
        this.storeCode.set((Object)((String)this.vClone.storeCode.get()));
        this.code.set((Object)((String)this.vClone.code.get()));
        this.currency.set((Object)((String)this.vClone.currency.get()));
        this.purchaseType.set((Object)((String)this.vClone.purchaseType.get()));
        this.paymentTerm.set((Object)((String)this.vClone.paymentTerm.get()));
        this.sapCode.set((Object)((String)this.vClone.sapCode.get()));
        this.costCenter.set((Object)((String)this.vClone.costCenter.get()));
        this.supplierCode.set((Object)((String)this.vClone.supplierCode.get()));
        this.supplierName.set((Object)((String)this.vClone.supplierName.get()));
        this.dateCreated.set((Object)((java.util.Date)this.vClone.dateCreated.get()));
        this.dueDate.set((Object)((java.util.Date)this.vClone.dueDate.get()));
        this.syncFlag.set(this.vClone.syncFlag.get());
        this.status.set((Object)((String)this.vClone.status.get()));
        this.currentStage.set((Object)((String)this.vClone.currentStage.get()));
        this.parentTemplateDescription.set((Object)((String)this.vClone.parentTemplateDescription.get()));
        this.setMustClone(true);
    }

    @Override
    public void insert() throws Exception {
        try {
            String query = "INSERT INTO PurchaseOrder (code,sapCode,supplierCode,supplierName,dateCreated,dueDate,status,syncFlag,currentStage,parentTemplateDescription,purchaseType,paymentTerm,currency,storeCode,createComment,isSaveForPDN,costCenter) Values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
            ParameterValue[] parameterValues = new ParameterValue[]{new ParameterValue("code", JDBCType.VARCHAR, this.code.get()), new ParameterValue("sapCode", JDBCType.VARCHAR, this.sapCode.get()), new ParameterValue("supplierCode", JDBCType.VARCHAR, this.supplierCode.get()), new ParameterValue("supplierName", JDBCType.VARCHAR, this.supplierName.get()), new ParameterValue("dateCreated", JDBCType.TIMESTAMP, new Timestamp(((java.util.Date)this.dateCreated.get()).getTime())), new ParameterValue("dueDate", JDBCType.TIMESTAMP, new Timestamp(((java.util.Date)this.dueDate.get()).getTime())), new ParameterValue("status", JDBCType.VARCHAR, this.status.get()), new ParameterValue("syncFlag", JDBCType.CHAR, this.syncFlag.get()), new ParameterValue("currentStage", JDBCType.VARCHAR, this.currentStage.get()), new ParameterValue("parentTemplateDescription", JDBCType.VARCHAR, this.parentTemplateDescription.get()), new ParameterValue("purchaseType", JDBCType.VARCHAR, this.purchaseType.get()), new ParameterValue("paymentTerm", JDBCType.VARCHAR, this.paymentTerm.get()), new ParameterValue("currency", JDBCType.VARCHAR, this.currency.get()), new ParameterValue("storeCode", JDBCType.VARCHAR, this.storeCode.get()), new ParameterValue("createComment", JDBCType.VARCHAR, this.createComment.get()), new ParameterValue("isSaveForPDN", JDBCType.CHAR, this.isSaveForPDN.get()), new ParameterValue("costCenter", JDBCType.VARCHAR, this.costCenter.get())};
            this.getDbAccess().performDbOperation(query, parameterValues);
            this.vClone = this.clone();
        }
        catch (Exception e) {
            this.rollBack();
            this.isCloned = false;
            throw e;
        }
    }

    @Override
    public void update() throws Exception {
        try {
            String query = "UPDATE PurchaseOrder SET code=?,sapCode=?,supplierCode=?,supplierName=?,dateCreated=?,dueDate=?,status=?,syncFlag=?,currentStage=?,parentTemplateDescription=?,purchaseType=?,paymentTerm=?,currency=?,storeCode=?,createComment=?,isSaveForPDN=?,costCenter=? where code=?";
            ParameterValue[] parameterValues = new ParameterValue[]{new ParameterValue("code", JDBCType.VARCHAR, this.code.get()), new ParameterValue("sapCode", JDBCType.VARCHAR, this.sapCode.get()), new ParameterValue("supplierCode", JDBCType.VARCHAR, this.supplierCode.get()), new ParameterValue("supplierName", JDBCType.VARCHAR, this.supplierName.get()), new ParameterValue("dateCreated", JDBCType.TIMESTAMP, new Timestamp(((java.util.Date)this.dateCreated.get()).getTime())), new ParameterValue("dueDate", JDBCType.TIMESTAMP, new Timestamp(((java.util.Date)this.dueDate.get()).getTime())), new ParameterValue("status", JDBCType.VARCHAR, this.status.get()), new ParameterValue("syncFlag", JDBCType.CHAR, this.syncFlag.get()), new ParameterValue("code", JDBCType.VARCHAR, this.vClone.code.get()), new ParameterValue("currentStage", JDBCType.VARCHAR, this.currentStage.get()), new ParameterValue("parentTemplateDescription", JDBCType.VARCHAR, this.parentTemplateDescription.get()), new ParameterValue("purchaseType", JDBCType.VARCHAR, this.purchaseType.get()), new ParameterValue("paymentTerm", JDBCType.VARCHAR, this.paymentTerm.get()), new ParameterValue("currency", JDBCType.VARCHAR, this.currency.get()), new ParameterValue("storeCode", JDBCType.VARCHAR, this.storeCode.get()), new ParameterValue("createComment", JDBCType.VARCHAR, this.createComment.get()), new ParameterValue("isSaveForPDN", JDBCType.CHAR, this.isSaveForPDN.get()), new ParameterValue("costCenter", JDBCType.VARCHAR, this.costCenter.get()), new ParameterValue("code", JDBCType.VARCHAR, this.vClone.code.get())};
            this.getDbAccess().performDbOperation(query, parameterValues, true);
            this.vClone = this.clone();
        }
        catch (Exception e) {
            if (e instanceof BaseConcurrencyException) {
                String message = e.getMessage();
                throw new ConsequentialConcurrencyException(message, (Object)null);
            }
            throw e;
        }
    }

    @Override
    public void delete() {
        String query = "DELETE FROM PurchaseOrder WHERE code=?";
        ParameterValue[] parameterValues = new ParameterValue[]{new ParameterValue("code", JDBCType.VARCHAR, this.code.get())};
        try {
            this.getDbAccess().performDbOperation(query, parameterValues);
        }
        catch (Exception ex) {
            Logger.getLogger(Customer.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public void beforeInsert() {
    }

    @Override
    public void afterInsert() {
    }

    @Override
    public void beforeUpdate() {
    }

    @Override
    public void afterUpdate() {
    }

    @Override
    public Searchable getSearchable() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void initializeListener() {
        this.total.addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                PurchaseOrder.this.setTotal((Double)newValue);
            }
        });
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        PurchaseOrder stockItem = (PurchaseOrder)object;
        if (stockItem.code.get() == null || this.code.get() == null) {
            return false;
        }
        return ((String)this.code.get()).equals(stockItem.code.get());
    }

    @Override
    public void recalculateTotal() {
        this.total.set(0.0);
        for (PurchaseLineItem item : this.items) {
            if (item.getState() == ObjectState.Removed) continue;
            if (item.getQtyChangeable() > 0 && item.getQuantity() > 0) {
                this.setTotal(this.total.get() + (double)item.getQtyChangeable() * item.getPrice() + item.getTax());
                continue;
            }
            if (item.getQtyChangeable() == 0 && (item.getQuantity() > 0 || item.editQtyProperty().get() > 0)) {
                if (item.editQtyProperty().get() > 0) {
                    this.setTotal(this.total.get() + (double)item.editQtyProperty().get() * item.editPriceProperty().get() + item.getTax());
                    continue;
                }
                this.setTotal(this.total.get() + (double)item.getQuantity() * item.getPrice() + item.getTax() + item.getTax());
                continue;
            }
            this.setTotal(this.total.get() + item.getPrice());
        }
    }
}

