/*
 * Decompiled with CFR 0.152.
 */
package com.xputertechnologies.santa;

import com.xputertechnologies.santa.DbEntity;
import com.xputertechnologies.santa.IPurchase;
import com.xputertechnologies.santa.PurchaseItemSerial;
import com.xputertechnologies.santa.core.BaseConcurrencyException;
import com.xputertechnologies.santa.core.ConsequentialConcurrencyException;
import com.xputertechnologies.santa.core.DataAccess;
import com.xputertechnologies.santa.core.ObjectState;
import com.xputertechnologies.santa.core.ParameterValue;
import com.xputertechnologies.santa.core.Searchable;
import com.xputertechnologies.santa.list.PurchaseItemSerialDataList;
import java.sql.JDBCType;
import java.util.UUID;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;

public class PurchaseLineItem
extends DbEntity {
    ObservableList<PurchaseItemSerial> serials = FXCollections.observableArrayList();
    private StringProperty lastPurchaseCurrency = new SimpleStringProperty();
    private StringProperty lastPurchaseDate = new SimpleStringProperty();
    private DoubleProperty lastPurchasePrice = new SimpleDoubleProperty(0.0);
    private DoubleProperty lineTotalWithTax = new SimpleDoubleProperty(0.0);
    private IntegerProperty currentQty = new SimpleIntegerProperty(0);
    private IntegerProperty soldOutMonth = new SimpleIntegerProperty(0);
    IPurchase parentPurchase;
    private int sn;
    public boolean approved = false;
    private BooleanProperty isDeleted = new SimpleBooleanProperty(false);
    private boolean isCloned;
    DataAccess dt = this.getDbAccess();
    private IntegerProperty qtyChangeable = new SimpleIntegerProperty(0);
    private IntegerProperty editQty = new SimpleIntegerProperty(0){

        public void set(int value) {
            super.set(value);
        }
    };
    private IntegerProperty quantity = new SimpleIntegerProperty(){

        public void set(int value) {
            super.set(value);
        }
    };
    private IntegerProperty qtySaved = new SimpleIntegerProperty(){

        public void set(int value) {
            super.set(value);
        }
    };
    private IntegerProperty openQty = new SimpleIntegerProperty(){

        public void set(int value) {
            super.set(value);
        }
    };
    private IntegerProperty returnedQty = new SimpleIntegerProperty(0);
    private DoubleProperty editPrice = new SimpleDoubleProperty(){

        public void set(double value) {
            super.set(value);
        }
    };
    private DoubleProperty tax = new SimpleDoubleProperty();
    private DoubleProperty price = new SimpleDoubleProperty();
    private DoubleProperty lineTotal = new SimpleDoubleProperty();
    private IntegerProperty lineNumber = new SimpleIntegerProperty(this, "lineNumber", -1){

        public void set(int value) {
            super.set(value);
        }
    };
    private IntegerProperty baseLineNumber = new SimpleIntegerProperty(this, "baseLineNumber", 0){

        public void set(int value) {
            super.set(value);
        }
    };
    private StringProperty partNumber = new SimpleStringProperty("");
    private StringProperty parentCode = new SimpleStringProperty("");
    private StringProperty taxCode = new SimpleStringProperty("");
    private StringProperty storeCode = new SimpleStringProperty("Isolo");
    private StringProperty costCenter = new SimpleStringProperty("");
    private StringProperty currency = new SimpleStringProperty("");
    private StringProperty code = new SimpleStringProperty(UUID.randomUUID().toString());
    private StringProperty itemCode = new SimpleStringProperty();
    private StringProperty itemName = new SimpleStringProperty("");
    public PurchaseLineItem vClone;

    public ObservableList<PurchaseItemSerial> getSerials() {
        return this.serials;
    }

    public StringProperty lastPurchaseCurrencyProperty() {
        return this.lastPurchaseCurrency;
    }

    public StringProperty lastPurchaseDateProperty() {
        return this.lastPurchaseDate;
    }

    public DoubleProperty lastPurchasePriceProperty() {
        return this.lastPurchasePrice;
    }

    public DoubleProperty lineTotalWithTaxProperty() {
        return this.lineTotalWithTax;
    }

    public IntegerProperty currentQtyProperty() {
        return this.currentQty;
    }

    public IntegerProperty soldOutMonthProperty() {
        return this.soldOutMonth;
    }

    public int getSn() {
        return this.sn;
    }

    public IPurchase getParentPurchase() {
        return this.parentPurchase;
    }

    public void setParentPurchase(IPurchase parent) {
        this.parentPurchase = parent;
    }

    public void setSn(int sn) {
        this.sn = sn;
    }

    public Boolean getIsDeleted() {
        return this.isDeleted.get();
    }

    public void setIsDeleted(Boolean isDeleted) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.clone();
        }
        this.isDeleted.set(isDeleted.booleanValue());
        this.changeObjectState();
    }

    public BooleanProperty isDeletedProperty() {
        return this.isDeleted;
    }

    public IntegerProperty qtyChangeableProperty() {
        return this.qtyChangeable;
    }

    public int getQtyChangeable() {
        return this.qtyChangeable.get();
    }

    public int getEditQty() {
        return this.editQty.get();
    }

    public void setEditQty(int openQty) {
        this.editQty.set(openQty);
        if (openQty > 0) {
            this.setLineTotal((double)openQty * this.editPriceProperty().get());
        }
    }

    public IntegerProperty editQtyProperty() {
        return this.editQty;
    }

    public IntegerProperty quantityProperty() {
        return this.quantity;
    }

    public int getQuantity() {
        return this.quantity.get();
    }

    public void setQuantity(int quantity) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.clone();
        }
        this.quantity.set(quantity);
        if (quantity > 0) {
            this.setLineTotal(this.price.get() * (double)quantity);
        }
        this.changeObjectState();
    }

    public IntegerProperty qtySavedProperty() {
        return this.qtySaved;
    }

    public int getQtySaved() {
        return this.qtySaved.get();
    }

    public void setQtySaved(int qtySaved) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.clone();
        }
        this.qtySaved.set(qtySaved);
        this.changeObjectState();
    }

    public IntegerProperty openQuantityProperty() {
        return this.openQty;
    }

    public int getOpenQty() {
        return this.openQty.get();
    }

    public void setOpenQty(int openQty) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.clone();
        }
        this.openQty.set(openQty);
        this.changeObjectState();
    }

    public Integer getReturnedQty() {
        return this.returnedQty.get();
    }

    public IntegerProperty releaseQtyProperty() {
        return this.returnedQty;
    }

    public void setReturnedQty(Integer returnedQty) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.clone();
        }
        this.returnedQty.set(returnedQty.intValue());
        this.changeObjectState();
    }

    public double getEditPrice() {
        return this.price.get();
    }

    public void setEditPrice(double price) {
        this.editPrice.set(price);
        if (price > 0.0) {
            this.setLineTotal(price * (double)this.editQty.get());
        }
    }

    public DoubleProperty editPriceProperty() {
        return this.editPrice;
    }

    public DoubleProperty taxProperty() {
        return this.tax;
    }

    public double getTax() {
        return this.tax.get();
    }

    public void setTax(double tax) {
        this.tax.set(tax);
    }

    public DoubleProperty priceProperty() {
        return this.price;
    }

    public double getPrice() {
        return this.price.get();
    }

    public void setPrice(double price) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.clone();
        }
        this.price.set(price);
        this.setLineTotal(price * (double)this.quantity.get());
        this.changeObjectState();
    }

    public double getLineTotal() {
        return this.lineTotal.get();
    }

    public void setLineTotal(double lineTotal) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.clone();
        }
        this.lineTotal.set(lineTotal);
        if (this.parentPurchase != null) {
            this.parentPurchase.recalculateTotal();
        }
        this.changeObjectState();
    }

    public DoubleProperty lineTotalProperty() {
        return this.lineTotal;
    }

    public int getLineNumber() {
        return this.lineNumber.get();
    }

    public IntegerProperty lineNumberProperty() {
        return this.lineNumber;
    }

    public void setLineNumber(int lineNumber) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.clone();
        }
        this.lineNumber.set(lineNumber);
        this.changeObjectState();
    }

    public int getBaseLineNumber() {
        return this.baseLineNumber.get();
    }

    public IntegerProperty baseLineNumberProperty() {
        return this.baseLineNumber;
    }

    public void setBaseLineNumber(int baseLineNumber) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.clone();
        }
        this.baseLineNumber.set(baseLineNumber);
        this.changeObjectState();
    }

    public StringProperty partNumberProperty() {
        return this.partNumber;
    }

    public String getPartNumber() {
        return (String)this.partNumber.get();
    }

    public void setPartNumber(String partNumber) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.clone();
        }
        this.changeObjectState();
        this.partNumber.set((Object)partNumber);
    }

    public StringProperty parentCodeProperty() {
        return this.parentCode;
    }

    public String getParentCode() {
        return (String)this.parentCode.get();
    }

    public void setParentCode(String parentCode) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.clone();
        }
        this.changeObjectState();
        this.parentCode.set((Object)parentCode);
    }

    public StringProperty taxCodeProperty() {
        return this.taxCode;
    }

    public String getTaxCode() {
        return (String)this.taxCode.get();
    }

    public void setTaxCode(String taxCode) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.clone();
        }
        this.changeObjectState();
        this.taxCode.set((Object)taxCode);
    }

    public String getStoreCode() {
        return (String)this.storeCode.get();
    }

    public StringProperty storeCodeProperty() {
        return this.storeCode;
    }

    public void setStoreCode(String storeCode) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.clone();
        }
        this.storeCode.set((Object)storeCode);
        this.changeObjectState();
    }

    public String getCostCenter() {
        return (String)this.costCenter.get();
    }

    public StringProperty costCenterProperty() {
        return this.costCenter;
    }

    public void setCostCenter(String costCenter) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.clone();
        }
        this.costCenter.set((Object)costCenter);
        this.changeObjectState();
    }

    public String getCurrency() {
        return (String)this.currency.get();
    }

    public void setCurrency(String currency) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.clone();
        }
        this.currency.set((Object)currency);
        this.changeObjectState();
    }

    public StringProperty currencyProperty() {
        return this.currency;
    }

    public StringProperty codeProperty() {
        return this.code;
    }

    public String getCode() {
        return (String)this.code.get();
    }

    public void setCode(String code) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.clone();
        }
        this.changeObjectState();
        this.code.set((Object)code);
    }

    public StringProperty itemCodeProperty() {
        return this.itemCode;
    }

    public String getItemCode() {
        return (String)this.itemCode.get();
    }

    public void setItemCode(String itemCode) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.clone();
        }
        this.changeObjectState();
        this.itemCode.set((Object)itemCode);
    }

    public String getItemName() {
        return (String)this.itemName.get();
    }

    public StringProperty itemNameProperty() {
        return this.itemName;
    }

    public void setItemName(String itemName) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.clone();
        }
        this.itemName.set((Object)itemName);
        this.changeObjectState();
    }

    public PurchaseLineItem(DataAccess dbAccess) {
        super(dbAccess);
        this.initializeListener();
    }

    public void loadSerials() {
        PurchaseItemSerialDataList requestItemDataList = new PurchaseItemSerialDataList(this.getDbAccess());
        requestItemDataList.selectAll("Select * From PurchaseItemSerial  where ParentCode=?", new ParameterValue[]{new ParameterValue("ParentCode", JDBCType.VARCHAR, this.code.get())});
        this.serials.addAll(requestItemDataList.getOriginalList());
    }

    public PurchaseLineItem clone() {
        PurchaseLineItem chase = new PurchaseLineItem(this.dt);
        chase.setMustClone(false);
        chase.qtySaved.set(this.qtySaved.get());
        chase.quantity.set(this.quantity.get());
        chase.price.set(this.price.get());
        chase.itemCode.set((Object)((String)this.itemCode.get()));
        chase.itemName.set((Object)((String)this.itemName.get()));
        chase.openQty.set(this.openQty.get());
        chase.taxCode.set((Object)((String)this.taxCode.get()));
        chase.lineNumber.set(this.lineNumber.get());
        chase.baseLineNumber.set(this.baseLineNumber.get());
        chase.parentCode.set((Object)((String)this.parentCode.get()));
        chase.costCenter.set((Object)((String)this.costCenter.get()));
        chase.storeCode.set((Object)((String)this.storeCode.get()));
        chase.currency.set((Object)((String)this.currency.get()));
        chase.lineTotal.set(this.lineTotal.get());
        chase.code.set((Object)((String)this.code.get()));
        chase.returnedQty.set(this.returnedQty.get());
        chase.isDeleted.set(this.isDeleted.get());
        this.isCloned = true;
        return chase;
    }

    public void rollBack() {
        this.quantity.set(this.vClone.quantity.get());
        this.qtySaved.set(this.vClone.qtySaved.get());
        this.price.set(this.vClone.price.get());
        this.itemCode.set((Object)((String)this.vClone.itemCode.get()));
        this.itemName.set((Object)((String)this.vClone.itemName.get()));
        this.openQty.set(this.vClone.openQty.get());
        this.taxCode.set((Object)((String)this.vClone.taxCode.get()));
        this.lineNumber.set(this.vClone.lineNumber.get());
        this.baseLineNumber.set(this.vClone.baseLineNumber.get());
        this.parentCode.set((Object)((String)this.parentCode.get()));
        this.costCenter.set((Object)((String)this.costCenter.get()));
        this.storeCode.set((Object)((String)this.vClone.storeCode.get()));
        this.currency.set((Object)((String)this.currency.get()));
        this.lineTotal.set(this.lineTotal.get());
        this.code.set((Object)((String)this.code.get()));
        this.returnedQty.set(this.returnedQty.get());
        this.isDeleted.set(this.isDeleted.get());
        this.setIsCloned(false);
    }

    public PurchaseLineItem() {
    }

    public PurchaseLineItem(Integer quantity, Double price, String itemCode, String itemName, Integer openQty, String taxCode, Integer lineNumber, Integer baseLineNumber, String parentCode, String costCenter, String storeCode, String currency, Double lineTotal, String code, Integer returnedQty, Integer qtySaved, Boolean isDeleted, DataAccess de) {
        super(de);
        this.quantity.set(quantity.intValue());
        this.qtySaved.set(qtySaved.intValue());
        this.price.set(price.doubleValue());
        this.itemCode.set((Object)itemCode);
        this.itemName.set((Object)itemName);
        this.openQty.set(openQty.intValue());
        this.taxCode.set((Object)taxCode);
        this.lineNumber.set(lineNumber.intValue());
        this.baseLineNumber.set(baseLineNumber.intValue());
        this.parentCode.set((Object)parentCode);
        this.costCenter.set((Object)costCenter);
        this.storeCode.set((Object)storeCode);
        this.currency.set((Object)currency);
        this.lineTotal.set(lineTotal.doubleValue());
        this.code.set((Object)code);
        this.returnedQty.set(returnedQty.intValue());
        this.isDeleted.set(isDeleted.booleanValue());
        this.setState(ObjectState.Unchanged);
        this.setMustClone(true);
        this.initializeListener();
    }

    @Override
    public void insert() throws Exception {
        try {
            String query = "INSERT INTO PurchaseLineItem ( quantity,price,itemCode,itemName,openQty,taxCode,lineNumber,baseLineNumber,parentCode,costCenter,storeCode, currency,lineTotal,code,returnedQty,qtySaved,isDeleted) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
            this.dt.performDbOperation(query, new ParameterValue[]{new ParameterValue("quantity", JDBCType.INTEGER, this.quantity.get()), new ParameterValue("price", JDBCType.DOUBLE, this.price.get()), new ParameterValue("itemCode", JDBCType.VARCHAR, this.itemCode.get()), new ParameterValue("itemName", JDBCType.VARCHAR, this.itemName.get()), new ParameterValue("openQty", JDBCType.INTEGER, this.openQty.get()), new ParameterValue("taxCode", JDBCType.VARCHAR, this.taxCode.get()), new ParameterValue("lineNumber", JDBCType.INTEGER, this.lineNumber.get()), new ParameterValue("baseLineNumber", JDBCType.INTEGER, this.baseLineNumber.get()), new ParameterValue("parentCode", JDBCType.VARCHAR, this.parentCode.get()), new ParameterValue("costCenter", JDBCType.VARCHAR, this.costCenter.get()), new ParameterValue("storeCode", JDBCType.VARCHAR, this.storeCode.get()), new ParameterValue("currency", JDBCType.VARCHAR, this.currency.get()), new ParameterValue("lineTotal", JDBCType.DOUBLE, this.lineTotal.get()), new ParameterValue("code", JDBCType.VARCHAR, this.code.get()), new ParameterValue("returnedQty", JDBCType.INTEGER, this.returnedQty.get()), new ParameterValue("qtySaved", JDBCType.INTEGER, this.qtySaved.get()), new ParameterValue("isDeleted", JDBCType.CHAR, this.isDeleted.get())});
            this.vClone = this.clone();
        }
        catch (Exception ex) {
            this.rollBack();
            this.setIsCloned(false);
            throw ex;
        }
    }

    @Override
    public void update() throws ConsequentialConcurrencyException, Exception {
        try {
            String query = "UPDATE PurchaseLineItem set quantity=?,price=?,itemCode=?,itemName=?,openQty=?,taxCode=?,lineNumber=?,baseLineNumber=?,parentCode=?,costCenter=?,storeCode=?,currency=?,lineTotal=?,code=?,returnedQty=?,qtySaved=?,isDeleted=? where code=?";
            this.dt.performDbOperation(query, new ParameterValue[]{new ParameterValue("quantity", JDBCType.INTEGER, this.quantity.get()), new ParameterValue("price", JDBCType.DOUBLE, this.price.get()), new ParameterValue("itemCode", JDBCType.VARCHAR, this.itemCode.get()), new ParameterValue("itemName", JDBCType.VARCHAR, this.itemName.get()), new ParameterValue("openQty", JDBCType.INTEGER, this.openQty.get()), new ParameterValue("taxCode", JDBCType.VARCHAR, this.taxCode.get()), new ParameterValue("lineNumber", JDBCType.INTEGER, this.lineNumber.get()), new ParameterValue("baseLineNumber", JDBCType.INTEGER, this.baseLineNumber.get()), new ParameterValue("parentCode", JDBCType.VARCHAR, this.parentCode.get()), new ParameterValue("costCenter", JDBCType.VARCHAR, this.costCenter.get()), new ParameterValue("storeCode", JDBCType.VARCHAR, this.storeCode.get()), new ParameterValue("currency", JDBCType.VARCHAR, this.currency.get()), new ParameterValue("lineTotal", JDBCType.DOUBLE, this.lineTotal.get()), new ParameterValue("code", JDBCType.VARCHAR, this.code.get()), new ParameterValue("returnedQty", JDBCType.INTEGER, this.returnedQty.get()), new ParameterValue("qtySaved", JDBCType.INTEGER, this.qtySaved.get()), new ParameterValue("isDeleted", JDBCType.CHAR, this.isDeleted.get()), new ParameterValue("cloneCode", JDBCType.VARCHAR, this.vClone.code)});
            this.vClone = this.clone();
        }
        catch (Exception ex) {
            this.rollBack();
            this.setIsCloned(false);
            if (ex instanceof BaseConcurrencyException) {
                throw new BaseConcurrencyException("This object has been modified by another user, please reload your data", null);
            }
            throw ex;
        }
    }

    @Override
    public void delete() throws Exception {
        String query = "Delete FROM PurchaseLineItem where code=?";
        this.dt.performDbOperation(query, new ParameterValue[]{new ParameterValue("code", JDBCType.VARCHAR, this.code.get())});
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        return ((String)this.code.get()).equals(((PurchaseLineItem)o).getCode());
    }

    @Override
    public void beforeInsert() {
    }

    @Override
    public void afterInsert() {
        this.setState(ObjectState.Unchanged);
    }

    @Override
    public void beforeUpdate() {
    }

    @Override
    public void afterUpdate() {
    }

    @Override
    public Searchable getSearchable() {
        Searchable sb = new Searchable();
        sb.setTableName("PurchaseLineItem");
        String[] parameter = new String[6];
        parameter[0] = "quantity";
        parameter[1] = "price";
        parameter[2] = "itemCode";
        parameter[3] = "itemName";
        sb.setParameters(parameter);
        return sb;
    }

    public void setIsCloned(boolean isCloned) {
        this.isCloned = isCloned;
    }

    @Override
    public void initializeListener() {
        this.quantity.addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                PurchaseLineItem.this.setQuantity((Integer)newValue);
            }
        });
        this.editQty.addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                PurchaseLineItem.this.setEditQty((Integer)newValue);
            }
        });
        this.openQty.addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                PurchaseLineItem.this.setOpenQty((Integer)newValue);
            }
        });
        this.itemCode.addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                PurchaseLineItem.this.setItemCode(newValue);
            }
        });
        this.itemName.addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                PurchaseLineItem.this.setItemName(newValue);
            }
        });
        this.price.addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                PurchaseLineItem.this.setPrice((Double)newValue);
            }
        });
        this.editPrice.addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                PurchaseLineItem.this.setEditPrice((Double)newValue);
            }
        });
    }
}

