/*
 * Decompiled with CFR 0.152.
 */
package com.xputertechnologies.santa;

import com.xputertechnologies.santa.DbEntity;
import com.xputertechnologies.santa.Purchase;
import com.xputertechnologies.santa.Replenishment;
import com.xputertechnologies.santa.StockItem;
import com.xputertechnologies.santa.Unit;
import com.xputertechnologies.santa.core.BaseConcurrencyException;
import com.xputertechnologies.santa.core.ConsequentialConcurrencyException;
import com.xputertechnologies.santa.core.DataAccess;
import com.xputertechnologies.santa.core.ObjectState;
import com.xputertechnologies.santa.core.OutstandingQtyGreaterException;
import com.xputertechnologies.santa.core.ParameterValue;
import com.xputertechnologies.santa.core.Searchable;
import com.xputertechnologies.santa.list.PurchaseList;
import com.xputertechnologies.santa.list.StockItemList;
import com.xputertechnologies.santa.list.UnitDataList;
import java.sql.Date;
import java.sql.JDBCType;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.FloatProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleFloatProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;

public class PurchaseItem
extends DbEntity {
    public boolean isFromDb = false;
    public double incomeTot;
    public boolean IsCorrection = false;
    public PurchaseItem vClone;
    BooleanProperty istocash = new SimpleBooleanProperty();
    BooleanProperty iscollect = new SimpleBooleanProperty();
    BooleanProperty isReset = new SimpleBooleanProperty();
    BooleanProperty isCheck = new SimpleBooleanProperty();
    public String StockI;
    StockItem st = new StockItem();
    private boolean isCloned;
    DataAccess dt = this.getDbAccess();
    private StockItem parentStockItem;
    private Purchase parentPurchase;
    private FloatProperty quantityRecalc = new SimpleFloatProperty();
    private FloatProperty quantity = new SimpleFloatProperty(){

        public void set(float value) {
            super.set(value);
            if (value > 0.0f && !PurchaseItem.this.isCheck.get()) {
                PurchaseItem.this.isCheck.set(true);
            } else if (value == 0.0f && PurchaseItem.this.quantity.get() == 0.0f) {
                PurchaseItem.this.isCheck.set(false);
            }
        }
    };
    private DoubleProperty costPrice = new SimpleDoubleProperty();
    private DoubleProperty sellingPrice = new SimpleDoubleProperty();
    private FloatProperty outStandingQty = new SimpleFloatProperty(){

        public void set(float value) {
            super.set(value);
            if (value > 0.0f && !PurchaseItem.this.isCheck.get()) {
                PurchaseItem.this.isCheck.set(true);
            } else if (value == 0.0f && PurchaseItem.this.quantity.get() == 0.0f) {
                PurchaseItem.this.isCheck.set(false);
            }
        }
    };
    private String stockItemBarcode;
    public String purchaseCode;
    public String purchaseUnit;
    private Unit parentUnit;
    boolean prevDIv = false;
    double parentTotalAmt;
    String parentSupplierName;
    public boolean isOustandingEnd;
    public float prevOutstandingQty;
    public ObservableList<Replenishment> replenishments = FXCollections.observableArrayList();
    Replenishment replenishment;

    public PurchaseItem(StockItem stockItem, DataAccess dataAccess, Purchase parentPurchase) {
        super(dataAccess);
        this.setParentPurchase(parentPurchase);
        this.costPrice.set(stockItem.getCostPrice());
        this.sellingPrice.set(stockItem.getSellingPrice());
        this.setParentUnit(stockItem.getParentUnit());
        this.stockItemBarcode = stockItem.getItemCode();
        this.parentStockItem = stockItem;
        this.setMustClone(true);
        this.initializeListener();
        this.clone();
    }

    public PurchaseItem(DataAccess dbAccess) {
        super(dbAccess);
    }

    public boolean getIstocash() {
        return this.istocash.get();
    }

    public void setIstocash(boolean istocash) {
        this.istocash.set(istocash);
        this.collectCash();
    }

    public BooleanProperty istocashProperty() {
        return this.istocash;
    }

    public boolean getIscollect() {
        return this.iscollect.get();
    }

    public void setIscollect(boolean iscollect) {
        this.iscollect.set(iscollect);
        this.collectItem();
    }

    public BooleanProperty iscollectProperty() {
        return this.iscollect;
    }

    public boolean getIsReset() {
        return this.isReset.get();
    }

    public void setIsReset(boolean isReset) {
        this.isReset.set(isReset);
        this.resetOustanding();
    }

    public BooleanProperty isResetProperty() {
        return this.isReset;
    }

    public boolean getIsCheck() {
        return this.isCheck.get();
    }

    public void setIsCheck(boolean ischeck) {
        this.isCheck.set(ischeck);
    }

    public BooleanProperty isCheckProperty() {
        return this.isCheck;
    }

    public StockItem getParentStockItem() {
        if (this.parentStockItem == null) {
            this.loadParentStockItem();
        }
        return this.parentStockItem;
    }

    public void setParentStockItem(StockItem parentStockItem) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.clone();
        }
        this.parentStockItem = parentStockItem;
        this.stockItemBarcode = parentStockItem == null ? "" : parentStockItem.getItemCode();
        this.changeObjectState();
    }

    private void loadParentStockItem() {
        StockItemList compList = new StockItemList(this.getDbAccess());
        String query = "Select * From StockItem Where barcode=?";
        compList.selectAll(query, new ParameterValue[]{new ParameterValue("barcode", JDBCType.VARCHAR, this.stockItemBarcode)});
        if (compList.getOriginalList().size() > 0) {
            this.parentStockItem = (StockItem)compList.getOriginalList().get(0);
        }
    }

    public Purchase getParentPurchase() {
        if (this.parentPurchase == null) {
            this.loadParentPurchase();
        }
        return this.parentPurchase;
    }

    public void setParentPurchase(Purchase parentPurchase) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.clone();
        }
        this.parentPurchase = parentPurchase;
        this.purchaseCode = parentPurchase == null ? "" : parentPurchase.getPurchaseCode();
        this.changeObjectState();
    }

    private void loadParentPurchase() {
        PurchaseList purList = new PurchaseList(this.dt);
        String query = "Select * From Purchase Where purchaseCode=?";
        purList.selectAll(query, new ParameterValue[]{new ParameterValue("purchaseCode", JDBCType.VARCHAR, this.purchaseCode)});
        if (purList.getOriginalList().size() > 0) {
            this.parentPurchase = (Purchase)purList.getOriginalList().get(0);
        }
    }

    public float getQuantityRecalc() {
        return this.quantity.get();
    }

    public void setQuantityRecalc(float quantity) throws OutstandingQtyGreaterException {
        if (this.getParentUnit() != null && quantity != 0.0f) {
            this.quantityRecalc.set(quantity / this.getParentUnit().getQuantity());
        } else {
            this.quantityRecalc.set(quantity);
        }
    }

    public float getQuantity() {
        return this.quantity.get();
    }

    public void setQuantity(float quantity) throws OutstandingQtyGreaterException {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.clone();
        }
        this.quantity.set(quantity);
        this.changeObjectState();
        this.getParentPurchase().tracker.set(this.getParentPurchase().tracker.get() + 1);
    }

    public FloatProperty quantityRecalcProperty() {
        return this.quantityRecalc;
    }

    public FloatProperty quantityProperty() {
        return this.quantity;
    }

    public double getCostPrice() {
        return this.costPrice.get();
    }

    public void setCostPrice(double costPrice) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.clone();
        }
        this.costPrice.set(costPrice);
        this.getParentPurchase().tracker.set(this.getParentPurchase().tracker.get() + 1);
        this.changeObjectState();
    }

    public DoubleProperty costPriceProperty() {
        return this.costPrice;
    }

    public double getSellingPrice() {
        return this.sellingPrice.get();
    }

    public void setSellingPrice(double sellingPrice) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.clone();
        }
        this.sellingPrice.set(sellingPrice);
        this.changeObjectState();
    }

    public DoubleProperty sellingPriceProperty() {
        return this.sellingPrice;
    }

    public float getOutStandingQty() {
        return this.outStandingQty.get();
    }

    public void setOutStandingQty(float outStandingQty) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.clone();
        }
        this.outStandingQty.set(outStandingQty);
        this.changeObjectState();
        this.getParentPurchase().tracker.set(this.getParentPurchase().tracker.get() + 1);
    }

    public FloatProperty outStandingQtyProperty() {
        return this.outStandingQty;
    }

    public String getUnit() {
        return this.purchaseUnit;
    }

    public void setParentUnit(Unit un) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.clone();
        }
        this.parentUnit = un;
        this.purchaseUnit = un == null ? "" : un.getName();
        this.getParentPurchase().tracker.set(this.getParentPurchase().tracker.get() + 1);
        this.changeObjectState();
    }

    public void loadParentUnit() {
        UnitDataList unitList = new UnitDataList(this.getDbAccess());
        String query = "Select * From Unit Where name=?";
        unitList.selectAll(query, new ParameterValue[]{new ParameterValue("name", JDBCType.VARCHAR, this.purchaseUnit)});
        if (unitList.getOriginalList().size() > 0) {
            this.parentUnit = (Unit)unitList.getOriginalList().get(0);
            if (!this.prevDIv) {
                this.quantity.set(this.quantity.get() / this.parentUnit.getQuantity());
                this.outStandingQty.set(this.outStandingQty.get() / this.parentUnit.getQuantity());
            }
            this.setState(ObjectState.Unchanged);
        }
    }

    public Unit getParentUnit() {
        if (this.parentUnit == null) {
            this.loadParentUnit();
        }
        return this.parentUnit;
    }

    public PurchaseItem clone() {
        PurchaseItem chase = new PurchaseItem(this.dt);
        chase.setMustClone(false);
        chase.quantity.set(this.quantity.get());
        chase.costPrice.set(this.costPrice.get());
        chase.sellingPrice.set(this.sellingPrice.get());
        chase.purchaseUnit = this.purchaseUnit;
        chase.purchaseCode = this.purchaseCode;
        chase.outStandingQty.set(this.outStandingQty.get());
        chase.stockItemBarcode = this.stockItemBarcode;
        this.isCloned = true;
        return chase;
    }

    public PurchaseItem outerClone() {
        PurchaseItem chase = new PurchaseItem(this.dt);
        chase.setMustClone(false);
        chase.quantity.set(this.quantity.get());
        chase.costPrice.set(this.costPrice.get());
        chase.sellingPrice.set(this.sellingPrice.get());
        chase.purchaseUnit = this.purchaseUnit;
        chase.purchaseCode = this.purchaseCode;
        chase.outStandingQty.set(this.outStandingQty.get());
        chase.stockItemBarcode = this.stockItemBarcode;
        chase.isCheck.set(this.isCheck.get());
        chase.setMustClone(true);
        return chase;
    }

    public void rollBack() throws OutstandingQtyGreaterException {
        this.quantity.set(this.vClone.quantity.get());
        this.costPrice.set(this.vClone.costPrice.get());
        this.sellingPrice.set(this.vClone.sellingPrice.get());
        this.purchaseUnit = this.vClone.purchaseUnit;
        this.purchaseCode = this.vClone.purchaseCode;
        this.outStandingQty.set(this.vClone.outStandingQty.get());
        this.stockItemBarcode = this.vClone.stockItemBarcode;
        this.setIsCloned(false);
    }

    public PurchaseItem() {
    }

    public PurchaseItem(Float quantity, Float costPrice, Double sellingPrice, String purchaseUnit, String purchaseCode, String stockItemBarcode, Float outStandingOty, DataAccess de) {
        super(de);
        this.sellingPrice.set(sellingPrice.doubleValue());
        this.purchaseUnit = purchaseUnit;
        this.quantity.set(quantity.floatValue());
        this.costPrice.set((double)costPrice.floatValue());
        this.purchaseCode = purchaseCode;
        this.stockItemBarcode = stockItemBarcode;
        this.outStandingQty.set(outStandingOty.floatValue());
        this.setState(ObjectState.Unchanged);
        this.setMustClone(true);
        this.initializeListener();
        this.vClone = this.clone();
    }

    @Override
    public void insert() throws Exception {
        try {
            String query = "INSERT INTO PurchaseItem (quantity,costPrice,sellingPrice,purchaseUnit,purchaseCode,stockItemBarcode,outStandingQty) VALUES(?,?,?,?,?,?,?)";
            this.dt.performDbOperation(query, new ParameterValue[]{new ParameterValue("quantity", JDBCType.FLOAT, Float.valueOf(this.quantity.get())), new ParameterValue("costPrice", JDBCType.DOUBLE, this.costPrice.get()), new ParameterValue("sellingPrice", JDBCType.DOUBLE, this.sellingPrice.get()), new ParameterValue("purchaseUnit", JDBCType.VARCHAR, this.purchaseUnit), new ParameterValue("purchaseCode", JDBCType.VARCHAR, this.purchaseCode), new ParameterValue("stockItemBarcode", JDBCType.VARCHAR, this.stockItemBarcode), new ParameterValue("outStandingQty", JDBCType.FLOAT, Float.valueOf(this.outStandingQty.get()))});
            this.vClone = this.clone();
        }
        catch (Exception ex) {
            this.rollBack();
            this.setIsCloned(false);
            throw ex;
        }
    }

    @Override
    public void update() throws ConsequentialConcurrencyException, Exception {
        try {
            String query = "UPDATE PurchaseItem set quantity=?,costPrice=?,sellingPrice=?, purchaseUnit=?,purchaseCode=?,stockItemBarcode=?,outStandingQty=? where purchaseCode=? and stockItemBarcode=?";
            this.dt.performDbOperation(query, new ParameterValue[]{new ParameterValue("quantity", JDBCType.FLOAT, Float.valueOf(this.quantity.get())), new ParameterValue("costPrice", JDBCType.DOUBLE, this.costPrice.get()), new ParameterValue("sellingPrice", JDBCType.DOUBLE, this.sellingPrice.get()), new ParameterValue("purchaseUnit", JDBCType.VARCHAR, this.purchaseUnit), new ParameterValue("purchaseCode", JDBCType.VARCHAR, this.purchaseCode), new ParameterValue("stockItemBarcode", JDBCType.VARCHAR, this.stockItemBarcode), new ParameterValue("outStandingQty", JDBCType.FLOAT, Float.valueOf(this.outStandingQty.get())), new ParameterValue("clonePurchaseCode", JDBCType.VARCHAR, this.vClone.purchaseCode), new ParameterValue("cloneStockItemBarcode", JDBCType.VARCHAR, this.vClone.stockItemBarcode)});
            this.vClone = this.clone();
        }
        catch (Exception ex) {
            this.rollBack();
            this.setIsCloned(false);
            if (ex instanceof BaseConcurrencyException) {
                throw new BaseConcurrencyException("This object has been modified by another user, please reload your data", null);
            }
            throw ex;
        }
    }

    @Override
    public void delete() throws Exception {
        String query = "Delete FROM PurchaseItem where purchaseCode=? and stockItemBarcode=?";
        this.dt.performDbOperation(query, new ParameterValue[]{new ParameterValue("purchaseCode", JDBCType.VARCHAR, this.purchaseCode), new ParameterValue("stockItemBarcode", JDBCType.VARCHAR, this.stockItemBarcode)});
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        return this.stockItemBarcode.equals(((PurchaseItem)o).stockItemBarcode);
    }

    public void resetOustanding() {
        block0: {
            PurchaseItem oldPurchaseItem;
            Iterator iterator;
            if (!this.isCheck.get() || !this.isReset.get() || !(iterator = this.parentPurchase.getOldPurchaseItems().iterator()).hasNext() || !(oldPurchaseItem = (PurchaseItem)iterator.next()).equals(this) || this.getQuantity() == oldPurchaseItem.getQuantity() && this.parentStockItem.getQuantity() == oldPurchaseItem.getParentStockItem().getQuantity() && this.getOutStandingQty() == oldPurchaseItem.getOutStandingQty()) break block0;
            this.quantity.set(oldPurchaseItem.getQuantity());
            this.outStandingQty.set(oldPurchaseItem.getOutStandingQty());
            this.setParentStockItem(oldPurchaseItem.getParentStockItem());
            this.isOustandingEnd = false;
            this.replenishments.clear();
            this.prevOutstandingQty = 0.0f;
        }
    }

    public void collectItem() {
        if (this.isCheck.get() && this.iscollect.get()) {
            for (PurchaseItem oldPurchaseItem : this.parentPurchase.getOldPurchaseItems()) {
                if (!oldPurchaseItem.equals(this)) continue;
                if (!(this.outStandingQty.get() <= oldPurchaseItem.outStandingQty.get())) break;
                if (!this.isOustandingEnd) {
                    this.postReplenishment();
                    if (this.getParentStockItem().getDirectPurchaseQty() > 0.0) {
                        if (this.getParentStockItem().getDirectPurchaseQty() > (double)this.getOutStandingQty()) {
                            this.getParentStockItem().setDirectPurchaseQty(this.getParentStockItem().getDirectPurchaseQty() - (double)(this.getOutStandingQty() * this.getParentUnit().getQuantity()));
                        } else {
                            this.getParentStockItem().directPurchaseQtyProperty().set((double)(this.getOutStandingQty() * this.getParentUnit().getQuantity()) - this.getParentStockItem().getDirectPurchaseQty());
                        }
                    }
                    this.quantity.set(this.quantity.get() + this.outStandingQty.get());
                    this.getParentStockItem().quantityProperty().set(this.getParentStockItem().getQuantity() + this.getOutStandingQty() * this.getParentUnit().getQuantity());
                    if (this.prevOutstandingQty > 0.0f && this.getOutStandingQty() > 0.0f) {
                        this.outStandingQty.set(this.prevOutstandingQty - this.getOutStandingQty());
                        this.prevOutstandingQty = this.getOutStandingQty();
                    } else if (this.getOutStandingQty() > 0.0f && this.prevOutstandingQty == 0.0f) {
                        this.outStandingQty.set(oldPurchaseItem.getQuantity() + oldPurchaseItem.getOutStandingQty() - this.getQuantity());
                        this.prevOutstandingQty = this.getOutStandingQty();
                    }
                    if (this.getOutStandingQty() != 0.0f) break;
                    this.isOustandingEnd = true;
                    break;
                }
                this.outStandingQty.set(0.0f);
                break;
            }
        }
    }

    private void postReplenishment() {
        this.replenishment = new Replenishment(this.getDbAccess());
        this.replenishment.setParentPurchase(this.parentPurchase);
        this.replenishment.quantityProperty().set(this.getOutStandingQty() * this.getParentUnit().getQuantity());
        this.replenishment.setParentStockItem(this.parentStockItem);
        this.replenishment.commentProperty().set((Object)("Replenishment for Oustanding Qty" + this.getParentStockItem().getName() + " under purchase Code " + this.getParentPurchase().getPurchaseCode()));
        this.replenishment.balanceBfProperty().set(this.parentStockItem.getQuantity());
        this.replenishment.dateProperty().set((Object)Date.valueOf(this.parentStockItem.getParentCompany().getCurrentDay()));
        this.replenishments.add((Object)this.replenishment);
    }

    public void collectCash() {
        if (this.isCheck.get() && this.istocash.get()) {
            for (PurchaseItem oldPurchaseItem : this.parentPurchase.getOldPurchaseItems()) {
                if (!oldPurchaseItem.equals(this)) continue;
                if (!(this.outStandingQty.get() <= oldPurchaseItem.outStandingQty.get())) break;
                if (!this.isOustandingEnd) {
                    if (this.prevOutstandingQty > 0.0f && this.outStandingQty.get() > 0.0f) {
                        if (this.prevOutstandingQty != this.outStandingQty.get()) {
                            this.incomeTot += (double)this.outStandingQty.get() * this.costPrice.get();
                            this.outStandingQty.set(this.prevOutstandingQty - this.outStandingQty.get());
                            this.prevOutstandingQty = this.outStandingQty.get();
                        } else {
                            this.incomeTot += (double)this.outStandingQty.get() * this.costPrice.get();
                            this.outStandingQty.set(this.prevOutstandingQty - this.outStandingQty.get());
                        }
                    } else {
                        this.incomeTot += (double)this.outStandingQty.get() * this.costPrice.get();
                        this.outStandingQty.set(oldPurchaseItem.quantity.get() + oldPurchaseItem.outStandingQty.get() - this.quantity.get() - this.outStandingQty.get());
                        this.prevOutstandingQty = this.outStandingQty.get();
                    }
                    if (this.getOutStandingQty() != 0.0f) break;
                    this.isOustandingEnd = true;
                    break;
                }
                this.outStandingQty.set(0.0f);
                break;
            }
        }
    }

    @Override
    public void beforeInsert() {
    }

    @Override
    public void afterInsert() {
        this.setState(ObjectState.Unchanged);
    }

    @Override
    public void beforeUpdate() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void afterUpdate() {
        this.setState(ObjectState.Unchanged);
    }

    @Override
    public Searchable getSearchable() {
        Searchable sb = new Searchable();
        sb.setTableName("PurchaseItem");
        String[] parameter = new String[]{"quantity", "costPrice", "sellingPrice", "purchaseUnit", "purchaseCode", "stockItemBarcode"};
        parameter[6] = "outStandingQty";
        sb.setParameters(parameter);
        return sb;
    }

    public void setIsCloned(boolean isCloned) {
        this.isCloned = isCloned;
    }

    @Override
    public void initializeListener() {
        this.isCheck.addListener(new InvalidationListener(){

            public void invalidated(Observable observable) {
                PurchaseItem.this.getParentPurchase().tracker.set(PurchaseItem.this.getParentPurchase().tracker.get() + 1);
            }
        });
        this.quantity.addListener(new InvalidationListener(){

            public void invalidated(Observable observable) {
                PurchaseItem.this.getParentPurchase().tracker.set(PurchaseItem.this.getParentPurchase().tracker.get() + 1);
            }
        });
        this.quantity.addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                try {
                    PurchaseItem.this.setQuantity(((Float)newValue).floatValue());
                }
                catch (OutstandingQtyGreaterException ex) {
                    Logger.getLogger(PurchaseItem.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        });
        this.costPrice.addListener(new InvalidationListener(){

            public void invalidated(Observable observable) {
                PurchaseItem.this.getParentPurchase().tracker.set(PurchaseItem.this.getParentPurchase().tracker.get() + 1);
            }
        });
        this.costPrice.addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                PurchaseItem.this.setCostPrice(((Float)newValue).floatValue());
            }
        });
        this.sellingPrice.addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                PurchaseItem.this.setSellingPrice((Double)newValue);
            }
        });
        this.outStandingQty.addListener(new InvalidationListener(){

            public void invalidated(Observable observable) {
                PurchaseItem.this.getParentPurchase().tracker.set(PurchaseItem.this.getParentPurchase().tracker.get() + 1);
            }
        });
        this.outStandingQty.addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                PurchaseItem.this.setOutStandingQty(((Float)newValue).floatValue());
            }
        });
    }
}

