/*
 * Decompiled with CFR 0.152.
 */
package com.xputertechnologies.santa;

import com.xputertechnologies.santa.Customer;
import com.xputertechnologies.santa.DbEntity;
import com.xputertechnologies.santa.IPurchase;
import com.xputertechnologies.santa.PurchaseInvoice;
import com.xputertechnologies.santa.PurchaseLineItem;
import com.xputertechnologies.santa.PurchaseOrder;
import com.xputertechnologies.santa.core.BaseConcurrencyException;
import com.xputertechnologies.santa.core.ConsequentialConcurrencyException;
import com.xputertechnologies.santa.core.DataAccess;
import com.xputertechnologies.santa.core.ObjectState;
import com.xputertechnologies.santa.core.ParameterValue;
import com.xputertechnologies.santa.core.Searchable;
import java.sql.Date;
import java.sql.JDBCType;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;

public class PurchaseDeliveryNote
extends DbEntity
implements IPurchase {
    public String currency;
    private DoubleProperty total = new SimpleDoubleProperty();
    int counter = 0;
    public PurchaseOrder parentPO;
    private ObservableList<PurchaseLineItem> items = FXCollections.observableArrayList();
    private ObservableList<PurchaseInvoice> invoices = FXCollections.observableArrayList();
    public int DocEntry;
    public int DockNum;
    public int BaseDocumentNum;
    public double Total = 0.0;
    private StringProperty createComment = new SimpleStringProperty();
    private StringProperty OrderNo = new SimpleStringProperty();
    private StringProperty createdBy = new SimpleStringProperty();
    private StringProperty status = new SimpleStringProperty();
    private BooleanProperty syncFlag = new SimpleBooleanProperty();
    private StringProperty code = new SimpleStringProperty(UUID.randomUUID().toString());
    private StringProperty sapCode = new SimpleStringProperty();
    private StringProperty supplierCode = new SimpleStringProperty();
    private StringProperty supplierName = new SimpleStringProperty();
    private IntegerProperty baseEntry = new SimpleIntegerProperty();
    private StringProperty poCode = new SimpleStringProperty();
    private ObjectProperty<java.util.Date> dateCreated = new SimpleObjectProperty((Object)Date.valueOf(LocalDate.now()));
    private ObjectProperty<java.util.Date> dueDate = new SimpleObjectProperty((Object)Date.valueOf(LocalDate.now()));
    public PurchaseDeliveryNote vClone;
    private boolean isCloned;
    DataAccess dt = this.getDbAccess();
    private StringProperty parentCode = new SimpleStringProperty();
    private int sn;

    public double getTotal() {
        return this.total.get();
    }

    public void setTotal(double lineTotal) {
        this.total.set(lineTotal);
    }

    public DoubleProperty totalProperty() {
        return this.total;
    }

    public void resetNumbering() {
        this.counter = 0;
        this.items.forEach(val -> {
            ++this.counter;
            val.setSn(this.counter);
        });
    }

    public ObservableList<PurchaseLineItem> getItems() {
        return this.items;
    }

    public ObservableList<PurchaseInvoice> getInvoces() {
        return this.invoices;
    }

    public StringProperty createCommentProperty() {
        return this.createComment;
    }

    public StringProperty OrderNoProperty() {
        return this.OrderNo;
    }

    public StringProperty createdByProperty() {
        return this.createdBy;
    }

    public StringProperty statusProperty() {
        return this.status;
    }

    public String getStatus() {
        return (String)this.status.get();
    }

    public void setStatus(String status) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.clone();
        }
        this.changeObjectState();
        this.status.set((Object)status);
    }

    public Boolean getSyncFlag() {
        return this.syncFlag.get();
    }

    public void setSyncFlag(Boolean syncFlag) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.clone();
        }
        this.syncFlag.set(syncFlag.booleanValue());
        this.changeObjectState();
    }

    public BooleanProperty syncFlagProperty() {
        return this.syncFlag;
    }

    public StringProperty codeProperty() {
        return this.code;
    }

    public String getCode() {
        return (String)this.code.get();
    }

    public void setCode(String code) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.clone();
        }
        this.changeObjectState();
        this.code.set((Object)code);
    }

    public StringProperty sapCodeProperty() {
        return this.sapCode;
    }

    public String getSapCode() {
        return (String)this.sapCode.get();
    }

    public void setSapCode(String sapCode) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.clone();
        }
        this.changeObjectState();
        this.sapCode.set((Object)sapCode);
    }

    public StringProperty supplierCodeProperty() {
        return this.supplierCode;
    }

    public String getSupplierCode() {
        return (String)this.supplierCode.get();
    }

    public void setSupplierCode(String supplierCode) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.clone();
        }
        this.changeObjectState();
        this.supplierCode.set((Object)supplierCode);
    }

    public StringProperty supplierNameProperty() {
        return this.supplierName;
    }

    public String getSupplierName() {
        return (String)this.supplierName.get();
    }

    public void setSupplierName(String supplierName) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.clone();
        }
        this.changeObjectState();
        this.supplierName.set((Object)supplierName);
    }

    public IntegerProperty baseEntryProperty() {
        return this.baseEntry;
    }

    public Integer getBaseEntry() {
        return this.baseEntry.get();
    }

    public void setBaseEntry(Integer baseEntry) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.clone();
        }
        this.changeObjectState();
        this.baseEntry.set(baseEntry.intValue());
    }

    public StringProperty poCodeProperty() {
        return this.poCode;
    }

    public String getPoCode() {
        return (String)this.poCode.get();
    }

    public void setPoCode(String poCode) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.clone();
        }
        this.changeObjectState();
        this.poCode.set((Object)poCode);
    }

    public java.util.Date getDateCreated() {
        return (java.util.Date)this.dateCreated.get();
    }

    public void setDateCreated(java.util.Date date) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.clone();
        }
        this.changeObjectState();
        this.dateCreated.set((Object)date);
    }

    public ObjectProperty<java.util.Date> dateCreatedProperty() {
        return this.dateCreated;
    }

    public java.util.Date getDueDate() {
        return (java.util.Date)this.dueDate.get();
    }

    public void setDueDate(java.util.Date dueDate) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.clone();
        }
        this.changeObjectState();
        this.dueDate.set((Object)dueDate);
    }

    public ObjectProperty<java.util.Date> dueDateProperty() {
        return this.dueDate;
    }

    public PurchaseDeliveryNote(DataAccess dt) {
        super(dt);
    }

    public StringProperty parentCodeProperty() {
        return this.parentCode;
    }

    public String getParentCode() {
        return (String)this.parentCode.get();
    }

    public void setParentCode(String parentCode) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.clone();
        }
        this.changeObjectState();
        this.parentCode.set((Object)parentCode);
    }

    public PurchaseDeliveryNote(String code, String sapCode, String supplierCode, String supplierName, java.util.Date dateCreated, java.util.Date dueDate, String poCode, Integer baseEntry, String status, Boolean syncFlag, String parentCode, DataAccess dbAccess) {
        super(dbAccess);
        this.syncFlag.set(syncFlag.booleanValue());
        this.status.set((Object)status);
        this.code.set((Object)code);
        this.sapCode.set((Object)sapCode);
        this.supplierCode.set((Object)supplierCode);
        this.supplierName.set((Object)supplierName);
        this.dateCreated.set((Object)dateCreated);
        this.dueDate.set((Object)dueDate);
        this.poCode.set((Object)poCode);
        this.baseEntry.set(baseEntry.intValue());
        this.setState(ObjectState.Unchanged);
        this.setMustClone(true);
        this.initializeListener();
    }

    public PurchaseDeliveryNote clone() {
        PurchaseDeliveryNote pnote = new PurchaseDeliveryNote(this.dt);
        pnote.setMustClone(false);
        pnote.code.set((Object)((String)this.code.get()));
        pnote.sapCode.set((Object)((String)this.sapCode.get()));
        pnote.supplierCode.set((Object)((String)this.supplierCode.get()));
        pnote.supplierName.set((Object)((String)this.supplierName.get()));
        pnote.dateCreated.set((Object)((java.util.Date)this.dateCreated.get()));
        pnote.dueDate.set((Object)((java.util.Date)this.dueDate.get()));
        pnote.poCode.set((Object)((String)this.poCode.get()));
        pnote.baseEntry.set(this.baseEntry.get());
        pnote.status.set((Object)((String)this.status.get()));
        pnote.syncFlag.set(this.syncFlag.get());
        pnote.parentCode.set((Object)((String)this.parentCode.get()));
        this.setMustClone(true);
        this.isCloned = true;
        return pnote;
    }

    protected void rollBack() {
        this.code.set((Object)((String)this.vClone.code.get()));
        this.sapCode.set((Object)((String)this.vClone.sapCode.get()));
        this.supplierCode.set((Object)((String)this.vClone.supplierCode.get()));
        this.supplierName.set((Object)((String)this.vClone.supplierName.get()));
        this.dateCreated.set((Object)((java.util.Date)this.vClone.dateCreated.get()));
        this.dueDate.set((Object)((java.util.Date)this.vClone.dueDate.get()));
        this.poCode.set((Object)((String)this.vClone.poCode.get()));
        this.baseEntry.set(this.vClone.baseEntry.get());
        this.syncFlag.set(this.vClone.syncFlag.get());
        this.status.set((Object)((String)this.vClone.status.get()));
        this.parentCode.set((Object)((String)this.vClone.parentCode.get()));
        this.setMustClone(true);
    }

    @Override
    public void insert() throws Exception {
        try {
            String query = "INSERT INTO PurchaseDeliveryNote (code,sapCode,supplierCode,supplierName,dateCreated,dueDate,poCode,baseEntry,status,syncFlag,parentCode) Values(?,?,?,?,?,?,?,?,?,?)";
            ParameterValue[] parameterValues = new ParameterValue[]{new ParameterValue("code", JDBCType.VARCHAR, this.code.get()), new ParameterValue("sapCode", JDBCType.VARCHAR, this.sapCode.get()), new ParameterValue("supplierCode", JDBCType.VARCHAR, this.supplierCode.get()), new ParameterValue("supplierName", JDBCType.VARCHAR, this.supplierName.get()), new ParameterValue("dateCreated", JDBCType.TIMESTAMP, new Timestamp(((java.util.Date)this.dateCreated.get()).getTime())), new ParameterValue("dueDate", JDBCType.TIMESTAMP, new Timestamp(((java.util.Date)this.dueDate.get()).getTime())), new ParameterValue("poCode", JDBCType.VARCHAR, this.poCode.get()), new ParameterValue("baseEntry", JDBCType.VARCHAR, this.baseEntry.get()), new ParameterValue("status", JDBCType.VARCHAR, this.status.get()), new ParameterValue("syncFlag", JDBCType.CHAR, this.syncFlag.get()), new ParameterValue("parentCode", JDBCType.VARCHAR, this.parentCode.get())};
            this.getDbAccess().performDbOperation(query, parameterValues);
            this.vClone = this.clone();
        }
        catch (Exception e) {
            this.rollBack();
            this.isCloned = false;
            throw e;
        }
    }

    @Override
    public void update() throws Exception {
        try {
            String query = "UPDATE PurchaseDeliveryNote SET code=?,sapCode=?,supplierCode=?,supplierName=?,dateCreated=?,dueDate=?,poCode=?,baseEntry=?,status=?,syncFlag=?  where code=?";
            ParameterValue[] parameterValues = new ParameterValue[]{new ParameterValue("code", JDBCType.VARCHAR, this.code.get()), new ParameterValue("sapCode", JDBCType.VARCHAR, this.sapCode.get()), new ParameterValue("supplierCode", JDBCType.VARCHAR, this.supplierCode.get()), new ParameterValue("supplierName", JDBCType.VARCHAR, this.supplierName.get()), new ParameterValue("dateCreated", JDBCType.TIMESTAMP, new Timestamp(((java.util.Date)this.dateCreated.get()).getTime())), new ParameterValue("dueDate", JDBCType.TIMESTAMP, new Timestamp(((java.util.Date)this.dueDate.get()).getTime())), new ParameterValue("poCode", JDBCType.VARCHAR, this.poCode.get()), new ParameterValue("baseEntry", JDBCType.VARCHAR, this.baseEntry.get()), new ParameterValue("status", JDBCType.VARCHAR, this.status.get()), new ParameterValue("syncFlag", JDBCType.CHAR, this.syncFlag.get()), new ParameterValue("parentCode", JDBCType.VARCHAR, this.parentCode.get()), new ParameterValue("code", JDBCType.VARCHAR, this.vClone.code.get())};
            this.getDbAccess().performDbOperation(query, parameterValues, true);
            this.vClone = this.clone();
        }
        catch (Exception e) {
            if (e instanceof BaseConcurrencyException) {
                String message = e.getMessage();
                throw new ConsequentialConcurrencyException(message, (Object)null);
            }
            throw e;
        }
    }

    @Override
    public void delete() {
        String query = "DELETE FROM PurchaseDeliveryNote WHERE code=?";
        ParameterValue[] parameterValues = new ParameterValue[]{new ParameterValue("code", JDBCType.VARCHAR, this.code.get())};
        try {
            this.getDbAccess().performDbOperation(query, parameterValues);
        }
        catch (Exception ex) {
            Logger.getLogger(Customer.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public void beforeInsert() {
    }

    @Override
    public void afterInsert() {
    }

    @Override
    public void beforeUpdate() {
    }

    @Override
    public void afterUpdate() {
    }

    @Override
    public Searchable getSearchable() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void initializeListener() {
        this.total.addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                PurchaseDeliveryNote.this.setTotal((Double)newValue);
            }
        });
    }

    @Override
    public void recalculateTotal() {
        this.total.set(0.0);
        for (PurchaseLineItem item : this.items) {
            if (item.getQtyChangeable() > 0 && item.getQuantity() > 0) {
                this.setTotal(this.total.get() + (double)item.getQtyChangeable() * item.getPrice() + item.getTax());
                continue;
            }
            if (item.getQtyChangeable() == 0 && item.getQuantity() > 0) {
                this.setTotal(this.total.get() + (double)item.getQuantity() * item.getPrice() + item.getTax());
                continue;
            }
            this.setTotal(this.total.get() + item.getPrice());
        }
    }
}

