/*
 * Decompiled with CFR 0.152.
 */
package com.xputertechnologies.santa;

import com.xputertechnologies.santa.BatchSale;
import com.xputertechnologies.santa.BatchStatusEnum;
import com.xputertechnologies.santa.Company;
import com.xputertechnologies.santa.Customer;
import com.xputertechnologies.santa.DbEntity;
import com.xputertechnologies.santa.PaymentBatchHistory;
import com.xputertechnologies.santa.core.BaseConcurrencyException;
import com.xputertechnologies.santa.core.ConsequentialConcurrencyException;
import com.xputertechnologies.santa.core.DataAccess;
import com.xputertechnologies.santa.core.ObjectState;
import com.xputertechnologies.santa.core.ParameterValue;
import com.xputertechnologies.santa.core.Searchable;
import com.xputertechnologies.santa.list.BatchSaleDataList;
import com.xputertechnologies.santa.list.CompanyDataList;
import java.sql.Date;
import java.sql.JDBCType;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.time.LocalDate;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.beans.binding.StringBinding;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;

public class PaymentBatch
extends DbEntity {
    public boolean edited = false;
    public boolean isReadOnly = false;
    private ObservableList<PaymentBatchHistory> histories = FXCollections.observableArrayList();
    int counter = 0;
    public double initialAmt;
    public double initialAmountDeposited = 0.0;
    private DoubleProperty currentAmt = new SimpleDoubleProperty();
    private DoubleProperty amountNotCash = new SimpleDoubleProperty();
    private DoubleProperty amountDeposited = new SimpleDoubleProperty();
    private StringProperty adminRemark = new SimpleStringProperty("");
    private StringProperty remark = new SimpleStringProperty("");
    private StringProperty accountNo = new SimpleStringProperty("");
    private StringProperty bankName = new SimpleStringProperty("");
    private StringProperty dateCreatedString = new SimpleStringProperty("");
    private StringProperty dueDateString = new SimpleStringProperty("");
    private StringProperty tellerNo = new SimpleStringProperty("");
    private StringProperty status = new SimpleStringProperty(BatchStatusEnum.Created.name());
    private StringProperty syncError = new SimpleStringProperty();
    private DoubleProperty amount = new SimpleDoubleProperty();
    private StringProperty batchCode = new SimpleStringProperty();
    private BooleanProperty syncFlag = new SimpleBooleanProperty();
    private StringProperty batchUser = new SimpleStringProperty("");
    private StringProperty store = new SimpleStringProperty();
    private ObjectProperty<java.util.Date> dateCreated = new SimpleObjectProperty((Object)Date.valueOf(LocalDate.now()));
    private ObservableList<BatchSale> batchSales = FXCollections.observableArrayList();
    public PaymentBatch vClone;
    private boolean isCloned;
    DataAccess dt = this.getDbAccess();
    private int sn;
    public DecimalFormat df = new DecimalFormat("#.##");
    public DecimalFormat dfTot = new DecimalFormat("#,###.##");
    public IntegerProperty tracker = new SimpleIntegerProperty();
    double result;
    double resultNotCash = 0.0;
    public StringBinding totalAmountBinding = new StringBinding(){

        protected String computeValue() {
            PaymentBatch.this.result = 0.0;
            if (PaymentBatch.this.batchSales.isEmpty()) {
                return "0.00";
            }
            if (PaymentBatch.this.batchSales.size() > 0) {
                PaymentBatch.this.batchSales.forEach(s -> PaymentBatch.this.result += s.getAmount());
            }
            PaymentBatch.this.amountProperty().set(PaymentBatch.this.result);
            return String.valueOf(PaymentBatch.this.dfTot.format(PaymentBatch.this.result));
        }
    };

    public ObservableList<PaymentBatchHistory> getHistories() {
        return this.histories;
    }

    public PaymentBatch deepClone() {
        PaymentBatch result = new PaymentBatch(this.dt);
        result.setAccountNo((String)this.accountNo.get());
        result.setAmount(this.amount.get());
        result.setAmountDeposited(this.amountDeposited.get());
        result.setAmountNotCash(this.amountNotCash.get());
        result.setBankName((String)this.bankName.get());
        result.setBatchCode((String)this.batchCode.get());
        result.setBatchUser((String)this.batchUser.get());
        result.setDateCreated((java.util.Date)this.dateCreated.get());
        result.setRemark((String)this.remark.get());
        result.setSn(this.sn);
        result.setStatus((String)this.status.get());
        result.setStore((String)this.store.get());
        result.setSyncError((String)this.syncError.get());
        result.setSyncFlag(this.syncFlag.get());
        result.setTellerNo((String)this.tellerNo.get());
        result.setState(this.getState());
        this.getBatchSales().forEach(val -> {
            BatchSale batchSale = new BatchSale(this.dt);
            batchSale.setAmount(val.getAmount());
            batchSale.setAmountNotCash(val.getAmountNotCash());
            batchSale.setBatchCode(val.getBatchCode());
            batchSale.setInvoiceNumber(val.getInvoiceNumber());
            batchSale.setSalesChannel(val.getSalesChannel());
            batchSale.setSn(val.getSn());
            batchSale.setState(val.getState());
            result.getBatchSales().add((Object)batchSale);
        });
        result.vClone = result.clone();
        return result;
    }

    public double getCurrentAmt() {
        return this.currentAmt.get();
    }

    public void setCurrentAmt(double currentAmt) {
        this.currentAmt.set(currentAmt);
    }

    public DoubleProperty currentAmtProperty() {
        return this.currentAmt;
    }

    public void resetNumbering() {
        this.counter = 0;
        this.batchSales.forEach(val -> {
            ++this.counter;
            val.setSn(this.counter);
        });
    }

    public double getAmountNotCash() {
        return this.amountNotCash.get();
    }

    public void setAmountNotCash(double amount) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.clone();
        }
        this.amountNotCash.set(amount);
        this.changeObjectState();
    }

    public DoubleProperty amountNotCashProperty() {
        return this.amountNotCash;
    }

    public double getAmountDeposited() {
        return this.amountDeposited.get();
    }

    public void setAmountDeposited(double amountDeposited) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.clone();
        }
        this.amountDeposited.set(amountDeposited);
        this.changeObjectState();
    }

    public DoubleProperty amountDepositedProperty() {
        return this.amountDeposited;
    }

    public StringProperty adminRemarkProperty() {
        return this.adminRemark;
    }

    public String getAdminRemark() {
        return (String)this.adminRemark.get();
    }

    public void setAdminRemark(String remark) {
        this.adminRemark.set((Object)remark);
    }

    public StringProperty remarkProperty() {
        return this.remark;
    }

    public String getRemark() {
        return (String)this.remark.get();
    }

    public void setRemark(String remark) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.clone();
        }
        this.remark.set((Object)remark);
        this.changeObjectState();
    }

    public StringProperty accountNoProperty() {
        return this.accountNo;
    }

    public String getAccountNo() {
        return (String)this.accountNo.get();
    }

    public void setAccountNo(String accountNo) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.clone();
        }
        this.accountNo.set((Object)accountNo);
        this.changeObjectState();
    }

    public StringProperty bankNameProperty() {
        return this.bankName;
    }

    public String getBankName() {
        return (String)this.bankName.get();
    }

    public void setBankName(String bankName) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.clone();
        }
        this.bankName.set((Object)bankName);
        this.changeObjectState();
    }

    public int getSn() {
        return this.sn;
    }

    public StringProperty dateCreatedStringProperty() {
        return this.dateCreatedString;
    }

    public void setSn(int sn) {
        this.sn = sn;
    }

    public StringProperty tellerNoProperty() {
        return this.tellerNo;
    }

    public String getTellerNo() {
        return (String)this.tellerNo.get();
    }

    public void setTellerNo(String tellerNo) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.clone();
        }
        this.tellerNo.set((Object)tellerNo);
        this.changeObjectState();
    }

    public StringProperty statusProperty() {
        return this.status;
    }

    public String getStatus() {
        return (String)this.status.get();
    }

    public void setStatus(String status) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.clone();
        }
        this.status.set((Object)status);
        this.changeObjectState();
    }

    public StringProperty syncErrorProperty() {
        return this.syncError;
    }

    public String getSyncError() {
        return (String)this.syncError.get();
    }

    public void setSyncError(String syncError) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.clone();
        }
        this.syncError.set((Object)syncError);
        this.changeObjectState();
    }

    public double getAmount() {
        return this.amount.get();
    }

    public void setAmount(double amount) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.clone();
        }
        this.amount.set(amount);
        this.changeObjectState();
    }

    public DoubleProperty amountProperty() {
        return this.amount;
    }

    public String getBatchCode() {
        return (String)this.batchCode.get();
    }

    public void setBatchCode(String batchCode) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.clone();
        }
        this.batchCode.set((Object)batchCode);
        this.changeObjectState();
    }

    public StringProperty batchCodeProperty() {
        return this.batchCode;
    }

    public Boolean getSyncFlag() {
        return this.syncFlag.get();
    }

    public void setSyncFlag(Boolean syncFlag) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.clone();
        }
        this.syncFlag.set(syncFlag.booleanValue());
        this.changeObjectState();
    }

    public String getBatchUser() {
        return (String)this.batchUser.get();
    }

    public void setBatchUser(String batchUser) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.clone();
        }
        this.batchUser.set((Object)batchUser);
        this.changeObjectState();
    }

    public StringProperty batchUserProperty() {
        return this.batchUser;
    }

    public BooleanProperty syncFlagProperty() {
        return this.syncFlag;
    }

    public StringProperty storeProperty() {
        return this.store;
    }

    public String getStore() {
        return (String)this.store.get();
    }

    public void setStore(String store) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.clone();
        }
        this.changeObjectState();
        this.store.set((Object)store);
    }

    public java.util.Date getDateCreated() {
        return (java.util.Date)this.dateCreated.get();
    }

    public void setDateCreated(java.util.Date date) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.clone();
        }
        this.changeObjectState();
        this.dateCreated.set((Object)date);
    }

    public ObjectProperty<java.util.Date> dateCreatedProperty() {
        return this.dateCreated;
    }

    public ObservableList<BatchSale> getBatchSales() {
        return this.batchSales;
    }

    public void loadSales() {
        BatchSaleDataList batchSaleDataList = new BatchSaleDataList(this.getDbAccess());
        batchSaleDataList.selectAll("Select * From BatchSale where batchCode=?", new ParameterValue[]{new ParameterValue("batchCode", JDBCType.VARCHAR, this.batchCode.get())});
        this.batchSales.addAll(batchSaleDataList.getOriginalList());
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        PaymentBatch obj = (PaymentBatch)object;
        if (obj.batchCode == null || this.batchCode == null) {
            return false;
        }
        return this.batchCode.equals(obj.batchCode);
    }

    public PaymentBatch(DataAccess dt) {
        super(dt);
    }

    public PaymentBatch(String batchUser, String store, DataAccess dt) {
        super(dt);
        this.batchUser.set((Object)batchUser);
        this.store.set((Object)store);
        this.tellerNo.set((Object)"");
        this.batchCode.set((Object)this.generateCode());
        this.initializeListener();
    }

    String generateCode() {
        CompanyDataList compList = new CompanyDataList(this.dt);
        String query = "Select * From Company";
        compList.selectAll(query, this.dt.getEmptyParameterValues());
        int count = ((Company)compList.getOriginalList().get(0)).getLastPaymentBatchCount();
        Object result = Integer.toString(count + 1);
        int lengh = 5 - ((String)result).length();
        for (int i = 0; i < lengh; ++i) {
            result = "0" + (String)result;
        }
        result = "Batch-" + ((Company)compList.getOriginalList().get(0)).getStoreCode() + "-" + (String)result;
        return result;
    }

    public PaymentBatch(String batchCode, java.util.Date dateCreated, String batchUser, String status, Boolean syncFlag, String store, double amount, String tellerNo, String syncError, String remark, double amountNotCash, String accNo, String bankName, double amountDeposited, DataAccess dbAccess) {
        super(dbAccess);
        this.accountNo.set((Object)accNo);
        this.bankName.set((Object)bankName);
        this.amountDeposited.set(amountDeposited);
        this.amountNotCash.set(amountNotCash);
        this.remark.set((Object)remark);
        this.batchUser.set((Object)batchUser);
        this.syncFlag.set(syncFlag.booleanValue());
        this.batchCode.set((Object)batchCode);
        this.store.set((Object)store);
        this.dateCreated.set((Object)dateCreated);
        this.status.set((Object)status);
        this.amount.set(amount);
        this.tellerNo.set((Object)tellerNo);
        this.syncError.set((Object)syncError);
        this.setState(ObjectState.Unchanged);
        this.setMustClone(true);
        this.initializeListener();
    }

    public PaymentBatch clone() {
        PaymentBatch obj = new PaymentBatch(this.dt);
        obj.setMustClone(false);
        obj.batchUser.set((Object)((String)this.batchUser.get()));
        obj.syncFlag.set(this.syncFlag.get());
        obj.batchCode.set((Object)((String)this.batchCode.get()));
        obj.store.set((Object)((String)this.store.get()));
        obj.syncFlag.set(this.syncFlag.get());
        obj.dateCreated.set((Object)((java.util.Date)this.dateCreated.get()));
        obj.status.set((Object)((String)this.status.get()));
        obj.amount.set(this.amount.get());
        obj.tellerNo.set((Object)((String)this.tellerNo.get()));
        obj.syncError.set((Object)((String)this.syncError.get()));
        obj.amountNotCash.set(this.amountNotCash.get());
        obj.remark.set((Object)((String)this.remark.get()));
        obj.bankName.set((Object)((String)this.bankName.get()));
        obj.accountNo.set((Object)((String)this.accountNo.get()));
        obj.amountDeposited.set(this.amountDeposited.get());
        this.setMustClone(true);
        this.isCloned = true;
        return obj;
    }

    protected void rollBack() {
        this.batchUser.set((Object)((String)this.vClone.batchUser.get()));
        this.syncFlag.set(this.vClone.syncFlag.get());
        this.batchCode.set((Object)((String)this.vClone.batchCode.get()));
        this.store.set((Object)((String)this.vClone.store.get()));
        this.dateCreated.set((Object)((java.util.Date)this.vClone.dateCreated.get()));
        this.status.set((Object)((String)this.vClone.status.get()));
        this.amount.set(this.vClone.amount.get());
        this.tellerNo.set((Object)((String)this.vClone.tellerNo.get()));
        this.syncError.set((Object)((String)this.vClone.syncError.get()));
        this.amountNotCash.set(this.vClone.amountNotCash.get());
        this.remark.set((Object)((String)this.vClone.remark.get()));
        this.bankName.set((Object)((String)this.vClone.bankName.get()));
        this.accountNo.set((Object)((String)this.vClone.accountNo.get()));
        this.amountDeposited.set(this.vClone.amountDeposited.get());
        this.setMustClone(true);
    }

    @Override
    public void insert() throws Exception {
        try {
            String query = "INSERT INTO PaymentBatch (batchUser,batchCode,syncFlag,store,dateCreated,status,amount,tellerNo,syncError,amountNotCash,remark,bankName,accountNo,amountDeposited) Values(?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
            ParameterValue[] parameterValues = new ParameterValue[]{new ParameterValue("batchUser", JDBCType.VARCHAR, this.batchUser.get()), new ParameterValue("batchCode", JDBCType.VARCHAR, this.batchCode.get()), new ParameterValue("syncFlag", JDBCType.CHAR, this.syncFlag.get()), new ParameterValue("store", JDBCType.VARCHAR, this.store.get()), new ParameterValue("dateCreated", JDBCType.TIMESTAMP, new Timestamp(((java.util.Date)this.dateCreated.get()).getTime())), new ParameterValue("status", JDBCType.VARCHAR, this.status.get()), new ParameterValue("amount", JDBCType.DOUBLE, this.amount.get()), new ParameterValue("tellerNo", JDBCType.VARCHAR, this.tellerNo.get()), new ParameterValue("syncError", JDBCType.VARCHAR, this.syncError.get()), new ParameterValue("amountNotCash", JDBCType.DOUBLE, this.amountNotCash.get()), new ParameterValue("remark", JDBCType.VARCHAR, this.remark.get()), new ParameterValue("bankName", JDBCType.VARCHAR, this.bankName.get()), new ParameterValue("accountNo", JDBCType.VARCHAR, this.accountNo.get()), new ParameterValue("amountDeposited", JDBCType.DOUBLE, this.amountDeposited.get())};
            this.getDbAccess().performDbOperation(query, parameterValues);
            this.vClone = this.clone();
        }
        catch (Exception e) {
            this.rollBack();
            this.isCloned = false;
            throw e;
        }
    }

    @Override
    public void update() throws Exception {
        try {
            String query = "UPDATE PaymentBatch SET batchUser=?,batchCode=?,syncFlag=?,store=?,dateCreated=?,status=?,amount=?,tellerNo=?,syncError=?,amountNotCash=?,remark=?,bankName=?,accountNo=?,amountDeposited=?  WHERE batchCode=?";
            ParameterValue[] parameterValues = new ParameterValue[]{new ParameterValue("batchUser", JDBCType.VARCHAR, this.batchUser.get()), new ParameterValue("batchCode", JDBCType.VARCHAR, this.batchCode.get()), new ParameterValue("syncFlag", JDBCType.CHAR, this.syncFlag.get()), new ParameterValue("store", JDBCType.VARCHAR, this.store.get()), new ParameterValue("dateCreated", JDBCType.TIMESTAMP, new Timestamp(((java.util.Date)this.dateCreated.get()).getTime())), new ParameterValue("status", JDBCType.VARCHAR, this.status.get()), new ParameterValue("amount", JDBCType.DOUBLE, this.amount.get()), new ParameterValue("tellerNo", JDBCType.VARCHAR, this.tellerNo.get()), new ParameterValue("syncError", JDBCType.VARCHAR, this.syncError.get()), new ParameterValue("amountNotCash", JDBCType.DOUBLE, this.amountNotCash.get()), new ParameterValue("remark", JDBCType.VARCHAR, this.remark.get()), new ParameterValue("bankName", JDBCType.VARCHAR, this.bankName.get()), new ParameterValue("accountNo", JDBCType.VARCHAR, this.accountNo.get()), new ParameterValue("amountDeposited", JDBCType.DOUBLE, this.amountDeposited.get()), new ParameterValue("descriptionClone", JDBCType.VARCHAR, this.vClone.batchCode.get())};
            this.getDbAccess().performDbOperation(query, parameterValues, true);
            this.vClone = this.clone();
        }
        catch (Exception e) {
            if (e instanceof BaseConcurrencyException) {
                String message = e.getMessage();
                throw new ConsequentialConcurrencyException(message, (Object)null);
            }
            throw e;
        }
    }

    @Override
    public void delete() {
        String query = "DELETE FROM PaymentBatch WHERE batchCode=?";
        ParameterValue[] parameterValues = new ParameterValue[]{new ParameterValue("batchCode", JDBCType.VARCHAR, this.batchCode.get())};
        try {
            this.getDbAccess().performDbOperation(query, parameterValues);
        }
        catch (Exception ex) {
            Logger.getLogger(Customer.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public String toString() {
        return (String)this.batchCode.get();
    }

    @Override
    public void beforeInsert() {
    }

    @Override
    public void afterInsert() {
    }

    @Override
    public void beforeUpdate() {
    }

    @Override
    public void afterUpdate() {
    }

    @Override
    public Searchable getSearchable() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void initializeListener() {
        this.amount.addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                PaymentBatch.this.setAmount((Double)newValue);
            }
        });
        this.amountDeposited.addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                PaymentBatch.this.setAmountDeposited((Double)newValue);
            }
        });
        this.tellerNo.addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                PaymentBatch.this.setTellerNo(newValue);
            }
        });
    }
}

