/*
 * Decompiled with CFR 0.152.
 */
package com.xputertechnologies.santa;

import com.xputertechnologies.santa.Company;
import com.xputertechnologies.santa.DbEntity;
import com.xputertechnologies.santa.User;
import com.xputertechnologies.santa.core.BaseConcurrencyException;
import com.xputertechnologies.santa.core.ConsequentialConcurrencyException;
import com.xputertechnologies.santa.core.DataAccess;
import com.xputertechnologies.santa.core.ObjectState;
import com.xputertechnologies.santa.core.ParameterValue;
import com.xputertechnologies.santa.core.Searchable;
import com.xputertechnologies.santa.list.CompanyDataList;
import com.xputertechnologies.santa.list.ExpensesDataList;
import com.xputertechnologies.santa.list.UserDataList;
import java.sql.Date;
import java.sql.JDBCType;
import java.text.DecimalFormat;
import java.time.LocalDate;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.beans.binding.StringBinding;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;

public class Expenses
extends DbEntity {
    public Expenses vClone;
    private boolean isCloned;
    private DataAccess dataAccess = this.getDbAccess();
    public boolean isEdit = false;
    private ObjectProperty<Date> date = new SimpleObjectProperty((Object)Date.valueOf(LocalDate.now()));
    private DoubleProperty amount = new SimpleDoubleProperty();
    private DoubleProperty balanceBf = new SimpleDoubleProperty();
    private User parentUser;
    private Company parentCompany;
    private StringProperty description = new SimpleStringProperty();
    private StringProperty userName = new SimpleStringProperty();
    private StringProperty code = new SimpleStringProperty();
    private String companyName;
    private ExpensesDataList expenses = new ExpensesDataList();
    public IntegerProperty tracker = new SimpleIntegerProperty();
    public DecimalFormat df = new DecimalFormat("#.##");
    public StringBinding totalAmountBinding = new StringBinding(){

        protected String computeValue() {
            double result = 0.0;
            for (Expenses object : Expenses.this.expenses.getOriginalList()) {
                if (!(object.getAmount() > 0.0)) continue;
                result += object.getAmount();
            }
            return String.valueOf(Float.valueOf(Expenses.this.df.format(result)));
        }
    };

    public Expenses(DataAccess dbAccess) {
        super(dbAccess);
    }

    public Expenses(Date date, double amount, String description, String userName, String code, String companyName, double balanceBf, DataAccess dbAccess) {
        super(dbAccess);
        this.balanceBf.set(balanceBf);
        this.date.set((Object)date);
        this.amount.set(amount);
        this.description.set((Object)description);
        this.userName.set((Object)userName);
        this.code.set((Object)code);
        this.companyName = companyName;
        this.setState(ObjectState.Unchanged);
        this.setMustClone(true);
        this.initializeListener();
        this.vClone = this.clone();
    }

    public ObjectProperty<Date> dateProperty() {
        return this.date;
    }

    public Date getDate() {
        return (Date)this.date.get();
    }

    public void setDate(Date date) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.clone();
        }
        this.changeObjectState();
        this.date.set((Object)date);
    }

    public DoubleProperty amountProperty() {
        return this.amount;
    }

    public double getAmount() {
        return this.amount.get();
    }

    public void setAmount(double amount) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.clone();
        }
    }

    public DoubleProperty balanceBfProperty() {
        return this.balanceBf;
    }

    public double getBalanceBf() {
        return this.balanceBf.get();
    }

    public void setBalanceBf(double balanceBf) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.clone();
        }
        this.balanceBf.set(balanceBf);
        this.changeObjectState();
    }

    public void setParentUser(User user) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.clone();
        }
        this.changeObjectState();
        this.userName.set((Object)(user == null ? "" : user.getUserName()));
    }

    public void loadParentUser() {
        UserDataList userList = new UserDataList(this.dataAccess);
        String query = "Select * From User ";
        userList.selectAll(query, new ParameterValue[]{new ParameterValue("userName", JDBCType.VARCHAR, this.userName.get())});
        if (userList.getOriginalList().size() > 0) {
            this.parentUser = (User)userList.getOriginalList().get(0);
        }
    }

    public User getParentUser() {
        if (this.parentUser == null) {
            this.loadParentUser();
        }
        return this.parentUser;
    }

    public void setParentCompany(Company company) {
        this.parentCompany = company;
        this.companyName = company == null ? "" : company.getName();
        this.changeObjectState();
    }

    public void loadParentCompany() {
        CompanyDataList companyList = new CompanyDataList();
        String query = "Select * From COMPANY Where name =?";
        companyList.selectAll(query, new ParameterValue[]{new ParameterValue("companyName", JDBCType.VARCHAR, this.companyName)});
        if (companyList.getOriginalList().size() > 0) {
            this.parentCompany = (Company)companyList.getOriginalList().get(0);
        }
    }

    public Company getParentCompany() {
        if (this.parentCompany == null) {
            this.loadParentCompany();
        }
        return this.parentCompany;
    }

    public StringProperty descriptionProperty() {
        return this.description;
    }

    public String getDescription() {
        return (String)this.description.get();
    }

    public void setDescription(String description) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.clone();
        }
        this.changeObjectState();
        this.description.set((Object)description);
    }

    public StringProperty userNameProperty() {
        return this.userName;
    }

    public String getUserName() {
        return (String)this.userName.get();
    }

    public void setUserName(String userName) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.clone();
        }
        this.changeObjectState();
        this.userName.set((Object)userName);
    }

    public StringProperty codeProperty() {
        return this.code;
    }

    public String getCode() {
        return (String)this.code.get();
    }

    public void setCode(String code) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.clone();
        }
        this.changeObjectState();
        this.code.set((Object)code);
    }

    public Expenses clone() {
        Expenses expenses = new Expenses(this.dataAccess);
        expenses.setMustClone(false);
        expenses.amount.set(this.amount.get());
        expenses.code.set((Object)((String)this.code.get()));
        expenses.companyName = this.companyName;
        expenses.date.set((Object)((Date)this.date.get()));
        expenses.description.set((Object)((String)this.description.get()));
        expenses.userName.set((Object)((String)this.userName.get()));
        expenses.balanceBf.set(this.balanceBf.get());
        this.setMustClone(true);
        this.isCloned = true;
        return expenses;
    }

    protected void rollBack() {
        this.amount.set(this.vClone.amount.get());
        this.code.set((Object)((String)this.vClone.code.get()));
        this.companyName = this.vClone.companyName;
        this.date.set((Object)((Date)this.vClone.date.get()));
        this.description.set((Object)((String)this.vClone.description.get()));
        this.userName.set((Object)((String)this.vClone.userName.get()));
        this.balanceBf.set(this.vClone.balanceBf.get());
        this.setMustClone(true);
    }

    @Override
    public void insert() throws Exception {
        try {
            String query = "INSERT INTO EXPENSES( \"date\", amount, description, userName,code,companyName,balanceBf) Values(?,?,?,?,?,?,?)";
            ParameterValue[] parameterValues = new ParameterValue[]{new ParameterValue("\"date\"", JDBCType.DATE, this.date.get()), new ParameterValue("amount", JDBCType.DOUBLE, this.amount.get()), new ParameterValue("description", JDBCType.VARCHAR, this.description.get()), new ParameterValue("userName", JDBCType.VARCHAR, this.userName.get()), new ParameterValue("code", JDBCType.VARCHAR, this.code.get()), new ParameterValue("companyName", JDBCType.VARCHAR, this.companyName), new ParameterValue("balanceBf", JDBCType.DOUBLE, this.balanceBf.get())};
            this.dataAccess.performDbOperation(query, parameterValues);
            this.vClone = this.clone();
        }
        catch (Exception e) {
            this.rollBack();
            this.isCloned = false;
            throw e;
        }
    }

    public ObservableList<Expenses> search(Date FromDate, Date ToDate, DataAccess dt) {
        ObservableList res = FXCollections.observableArrayList();
        ExpensesDataList result = new ExpensesDataList(dt);
        result.selectAll("select * from EXPENSES where  \"date\" between ? And ?", new ParameterValue[]{new ParameterValue("ParamFromDate", JDBCType.DATE, FromDate), new ParameterValue("ParamToDate", JDBCType.DATE, ToDate)});
        for (Expenses object : result.getOriginalList()) {
            res.add((Object)object);
        }
        return res;
    }

    @Override
    public void update() throws Exception {
        try {
            String query = "UPDATE EXPENSES SET  \"date\"=?, amount=?, description=?, userName=?,code=?, companyName=?, balanceBf=? WHERE code=? ";
            ParameterValue[] parameterValues = new ParameterValue[]{new ParameterValue("\"date\"", JDBCType.DATE, this.date.get()), new ParameterValue("amount", JDBCType.DOUBLE, this.amount.get()), new ParameterValue("description", JDBCType.VARCHAR, this.description.get()), new ParameterValue("userName", JDBCType.VARCHAR, this.userName.get()), new ParameterValue("code", JDBCType.VARCHAR, this.code.get()), new ParameterValue("companyName", JDBCType.VARCHAR, this.companyName), new ParameterValue("Code", JDBCType.VARCHAR, this.vClone.code.get()), new ParameterValue("balanceBf", JDBCType.DOUBLE, this.balanceBf.get())};
            this.dataAccess.performDbOperation(query, parameterValues, true);
            this.vClone = this.clone();
        }
        catch (Exception e) {
            if (e instanceof BaseConcurrencyException) {
                String message = e.getMessage();
                throw new ConsequentialConcurrencyException(message, (Object)null);
            }
            throw e;
        }
    }

    @Override
    public void delete() {
        try {
            String query = "DELETE FROM EXPENSES WHERE code=?";
            ParameterValue[] parameterValues = new ParameterValue[]{new ParameterValue("Code", JDBCType.VARCHAR, this.code.get())};
            this.dataAccess.performDbOperation(query, parameterValues);
        }
        catch (Exception ex) {
            Logger.getLogger(Expenses.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public Searchable getSearchable() {
        Searchable searchable = new Searchable();
        searchable.setTableName("Expenses");
        String[] parameters = new String[]{"\"date\"", "amount", "description", "userName", "code", "companyName"};
        searchable.setParameters(parameters);
        return searchable;
    }

    @Override
    public void beforeInsert() {
        this.getParentCompany().setLastIncomeExpenseCount(this.parentCompany.getLastIncomeExpenseCount() + 1);
        this.code.set((Object)String.valueOf(this.parentCompany.getLastIncomeExpenseCount()));
        this.balanceBf.set(this.getParentCompany().getBalanceBf());
        this.getParentCompany().setBalanceBf(this.getParentCompany().getBalanceBf() - this.getAmount());
        try {
            this.parentCompany.update();
        }
        catch (Exception e) {
            try {
                throw e;
            }
            catch (Exception ex) {
                Logger.getLogger(Expenses.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    @Override
    public void afterInsert() {
        this.setState(ObjectState.Unchanged);
    }

    @Override
    public void beforeUpdate() {
    }

    @Override
    public void afterUpdate() {
        this.setState(ObjectState.Unchanged);
    }

    public ExpensesDataList getExpenseItemsList() {
        return this.expenses;
    }

    public void setExpenseItemsList(ExpensesDataList expenses) {
        this.expenses = expenses;
    }

    @Override
    public void initializeListener() {
        this.date.addListener((ChangeListener)new ChangeListener<Date>(){

            public void changed(ObservableValue<? extends Date> observable, Date oldValue, Date newValue) {
                Expenses.this.setDate(newValue);
            }
        });
        this.amount.addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                Expenses.this.setAmount((Double)newValue);
            }
        });
        this.description.addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                Expenses.this.setDescription(newValue);
            }
        });
    }
}

