/*
 * Decompiled with CFR 0.152.
 */
package com.xputertechnologies.santa;

import com.xputertechnologies.santa.Company;
import com.xputertechnologies.santa.Customer;
import com.xputertechnologies.santa.DbEntity;
import com.xputertechnologies.santa.Sale;
import com.xputertechnologies.santa.User;
import com.xputertechnologies.santa.core.BaseConcurrencyException;
import com.xputertechnologies.santa.core.ConsequentialConcurrencyException;
import com.xputertechnologies.santa.core.DataAccess;
import com.xputertechnologies.santa.core.ObjectState;
import com.xputertechnologies.santa.core.ParameterValue;
import com.xputertechnologies.santa.core.Searchable;
import com.xputertechnologies.santa.list.CompanyDataList;
import com.xputertechnologies.santa.list.CustomerDataList;
import com.xputertechnologies.santa.list.CustomerPaymentDataList;
import com.xputertechnologies.santa.list.SaleList;
import com.xputertechnologies.santa.list.UserDataList;
import java.sql.Date;
import java.sql.JDBCType;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;

public class CustomerPayment
extends DbEntity {
    public CustomerPayment vClone;
    private boolean isCloned;
    private DataAccess dataAccess = this.getDbAccess();
    private String companyName;
    StringProperty comment = new SimpleStringProperty();
    private ObjectProperty<Date> date;
    private Customer parentCustomer;
    public Company parentCompanyName;
    private DoubleProperty amountPaid;
    private StringProperty receivingStaff;
    private Sale parentSale;
    private StringProperty code;
    private IntegerProperty saleInvoiceNumber;
    private StringProperty customerName;
    private User parentUser;

    public StringProperty commentProperty() {
        return this.comment;
    }

    public String getComment() {
        return (String)this.commentProperty().get();
    }

    public void setComment(String comment) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.clone();
        }
        this.changeObjectState();
        this.commentProperty().set((Object)comment);
    }

    public CustomerPayment() {
    }

    public CustomerPayment(String customerName, String code, Date date, double amountPaid, String receivingStaff, int saleInvoiceNumber, String comment, DataAccess dbAccess) {
        super(dbAccess);
        this.isConstructor = true;
        this.codeProperty().set((Object)code);
        this.dateProperty().set((Object)date);
        this.amountPaidProperty().set(amountPaid);
        this.receivingStaffProperty().set((Object)receivingStaff);
        this.saleInvoiceNumberProperty().set(saleInvoiceNumber);
        this.customerNameProperty().set((Object)customerName);
        this.commentProperty().set((Object)comment);
        this.setState(ObjectState.Unchanged);
        this.setMustClone(true);
        this.isConstructor = false;
        this.initializeListener();
    }

    public CustomerPayment(DataAccess dbAccess) {
        super(dbAccess);
    }

    public ObjectProperty<Date> dateProperty() {
        if (this.date == null) {
            this.date = new SimpleObjectProperty();
        }
        return this.date;
    }

    public Date getDate() {
        return (Date)this.dateProperty().get();
    }

    public void setDate(Date date) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.clone();
        }
        this.changeObjectState();
        this.dateProperty().set((Object)date);
    }

    public void setParentCustomer(Customer customer) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.clone();
        }
        this.changeObjectState();
        this.customerNameProperty().set((Object)(customer == null ? "" : customer.getEmail()));
    }

    public void loadParentCustomer() {
        CustomerDataList customerList = new CustomerDataList();
        String query = "Select * From Customer Where name =?";
        customerList.selectAll(query, new ParameterValue[]{new ParameterValue("customerName", JDBCType.VARCHAR, this.customerNameProperty().get())});
        if (customerList.getOriginalList().size() > 0) {
            this.parentCustomer = (Customer)customerList.getOriginalList().get(0);
        }
    }

    public Customer getParentCustomer() {
        if (this.parentCustomer == null) {
            this.loadParentCustomer();
        }
        return this.parentCustomer;
    }

    public void setParentCompanyName(Company cp) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.clone();
        }
        this.parentCompanyName = cp;
        this.companyName = cp == null ? "" : cp.getName();
        this.changeObjectState();
    }

    private void loadParentCompanyName() {
        CompanyDataList compList = new CompanyDataList(this.getDbAccess());
        String query = "Select * From Company ";
        compList.selectAll(query, this.getDbAccess().getEmptyParameterValues());
        if (compList.getOriginalList().size() > 0) {
            this.parentCompanyName = (Company)compList.getOriginalList().get(0);
        }
    }

    public Company getParentCompanyName() {
        if (this.parentCompanyName == null) {
            this.loadParentCompanyName();
        }
        return this.parentCompanyName;
    }

    public DoubleProperty amountPaidProperty() {
        if (this.amountPaid == null) {
            this.amountPaid = new SimpleDoubleProperty();
        }
        return this.amountPaid;
    }

    public double getAmountPaid() {
        return this.amountPaidProperty().get();
    }

    public void setAmountPaid(double amountPaid) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.clone();
        }
        this.changeObjectState();
        this.amountPaidProperty().set(amountPaid);
    }

    public StringProperty receivingStaffProperty() {
        if (this.receivingStaff == null) {
            this.receivingStaff = new SimpleStringProperty();
        }
        return this.receivingStaff;
    }

    public String getReceivingStaff() {
        return (String)this.receivingStaffProperty().get();
    }

    public void setReceivingStaff(String receivingStaff) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.clone();
        }
        this.changeObjectState();
        this.receivingStaffProperty().set((Object)receivingStaff);
    }

    public void setParentSale(Sale sale) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.clone();
        }
        this.changeObjectState();
        this.saleInvoiceNumberProperty().set(sale == null ? 0 : sale.getInvoiceNumber());
    }

    public void loadParentSale() {
        SaleList saleList = new SaleList(this.getDbAccess());
        String query = "Select * From Sale Where invoiceNumber =?";
        saleList.selectAll(query, new ParameterValue[]{new ParameterValue("saleinvoiceNumber", JDBCType.INTEGER, this.saleInvoiceNumberProperty().get())});
        if (saleList.getOriginalList().size() > 0) {
            this.parentSale = (Sale)saleList.getOriginalList().get(0);
        }
    }

    public Sale getParentSale() {
        if (this.parentSale == null) {
            this.loadParentSale();
        }
        return this.parentSale;
    }

    public StringProperty codeProperty() {
        if (this.code == null) {
            this.code = new SimpleStringProperty();
        }
        return this.code;
    }

    public String getCode() {
        return (String)this.codeProperty().get();
    }

    public void setCode(String code) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.clone();
        }
        this.changeObjectState();
        this.codeProperty().set((Object)code);
    }

    public IntegerProperty saleInvoiceNumberProperty() {
        if (this.saleInvoiceNumber == null) {
            this.saleInvoiceNumber = new SimpleIntegerProperty();
        }
        return this.saleInvoiceNumber;
    }

    public int getSaleInvoiceNumber() {
        return this.saleInvoiceNumberProperty().get();
    }

    public void setSaleInvoiceNumber(int saleInvoiceNumber) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.clone();
        }
        this.changeObjectState();
        this.saleInvoiceNumberProperty().set(saleInvoiceNumber);
    }

    public StringProperty customerNameProperty() {
        if (this.customerName == null) {
            this.customerName = new SimpleStringProperty();
        }
        return this.customerName;
    }

    public String getCustomerName() {
        return (String)this.customerNameProperty().get();
    }

    public void setCustomerName(String customerName) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.clone();
        }
        this.changeObjectState();
        this.customerNameProperty().set((Object)customerName);
    }

    public void setParentUser(User user) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.clone();
        }
        this.changeObjectState();
        this.receivingStaffProperty().set((Object)(user == null ? "" : user.getUserName()));
    }

    public void loadParentUser() {
        UserDataList userList = new UserDataList();
        String query = "Select * From User Where userName =?";
        userList.selectAll(query, new ParameterValue[]{new ParameterValue("receivingStaffName", JDBCType.VARCHAR, this.receivingStaff)});
        if (userList.getOriginalList().size() > 0) {
            this.parentUser = (User)userList.getOriginalList().get(0);
        }
    }

    public User getParentUser() {
        if (this.parentUser == null) {
            this.loadParentUser();
        }
        return this.parentUser;
    }

    public static CustomerPaymentDataList Search(String searchString, DataAccess da) {
        CustomerPaymentDataList customerPaymentDataList = new CustomerPaymentDataList(da);
        customerPaymentDataList.selectAll("Select * from CustomerPayment where CustomerName = ?", new ParameterValue[]{new ParameterValue("customername", JDBCType.VARCHAR, searchString)});
        return customerPaymentDataList;
    }

    public CustomerPayment clone() {
        CustomerPayment customerPayment = new CustomerPayment();
        customerPayment.setMustClone(false);
        customerPayment.amountPaidProperty().set(this.amountPaidProperty().get());
        customerPayment.codeProperty().set((Object)((String)this.codeProperty().get()));
        customerPayment.customerNameProperty().set((Object)((String)this.customerNameProperty().get()));
        customerPayment.dateProperty().set((Object)((Date)this.dateProperty().get()));
        customerPayment.receivingStaffProperty().set((Object)((String)this.receivingStaffProperty().get()));
        customerPayment.saleInvoiceNumberProperty().set(this.saleInvoiceNumberProperty().get());
        customerPayment.commentProperty().set((Object)((String)this.commentProperty().get()));
        this.setMustClone(true);
        this.isCloned = true;
        return customerPayment;
    }

    protected void rollBack() {
        this.amountPaidProperty().set(this.vClone.amountPaidProperty().get());
        this.codeProperty().set((Object)((String)this.vClone.codeProperty().get()));
        this.customerNameProperty().set((Object)((String)this.vClone.customerNameProperty().get()));
        this.dateProperty().set((Object)((Date)this.vClone.dateProperty().get()));
        this.receivingStaffProperty().set((Object)((String)this.vClone.receivingStaffProperty().get()));
        this.saleInvoiceNumberProperty().set(this.vClone.saleInvoiceNumberProperty().get());
        this.commentProperty().set((Object)((String)this.vClone.commentProperty().get()));
        this.setMustClone(true);
    }

    @Override
    public void insert() throws Exception {
        try {
            String query = "INSERT INTO CUSTOMERPAYMENT( customerName, code, \"date\", amountPaid,receivingStaff, saleInvoiceNumber,comment) Values(?,?,?,?,?,?,?)";
            ParameterValue[] parameterValues = new ParameterValue[]{new ParameterValue("customerName", JDBCType.VARCHAR, this.customerNameProperty().get()), new ParameterValue("code", JDBCType.VARCHAR, this.codeProperty().get()), new ParameterValue("date", JDBCType.DATE, this.dateProperty().get()), new ParameterValue("amountPaid", JDBCType.DOUBLE, this.amountPaidProperty().get()), new ParameterValue("receivingStaff", JDBCType.VARCHAR, this.receivingStaffProperty().get()), new ParameterValue("saleInvoiceNumber", JDBCType.INTEGER, this.saleInvoiceNumberProperty().get()), new ParameterValue("comment", JDBCType.VARCHAR, this.commentProperty().get())};
            this.dataAccess.performDbOperation(query, parameterValues);
            this.vClone = this.clone();
        }
        catch (Exception e) {
            this.rollBack();
            this.isCloned = false;
            throw e;
        }
    }

    @Override
    public void update() throws ConsequentialConcurrencyException, Exception {
        try {
            String query = "UPDATE CUSTOMERPAYMENT SET  customerName=?, code=?, \"date\"=?, amountPaid=?,receivingStaff=?, saleInvoiceNumber=?,comment=?  WHERE code=? ";
            ParameterValue[] parameterValues = new ParameterValue[]{new ParameterValue("customerName", JDBCType.VARCHAR, this.customerNameProperty().get()), new ParameterValue("code", JDBCType.VARCHAR, this.codeProperty().get()), new ParameterValue("date", JDBCType.DATE, this.dateProperty().get()), new ParameterValue("amountPaid", JDBCType.DOUBLE, this.amountPaidProperty().get()), new ParameterValue("receivingStaff", JDBCType.VARCHAR, this.receivingStaffProperty().get()), new ParameterValue("saleInvoiceNumber", JDBCType.INTEGER, this.saleInvoiceNumberProperty().get()), new ParameterValue("comment", JDBCType.VARCHAR, this.commentProperty().get()), new ParameterValue("Code", JDBCType.VARCHAR, this.vClone.codeProperty().get())};
            this.dataAccess.performDbOperation(query, parameterValues, true);
            this.vClone = this.clone();
        }
        catch (Exception e) {
            if (e instanceof BaseConcurrencyException) {
                String message = e.getMessage();
                throw new ConsequentialConcurrencyException(message, (Object)null);
            }
            throw e;
        }
    }

    @Override
    public void delete() throws Exception {
        try {
            String query = "DELETE FROM CUSTOMERPAYMENT WHERE code=?";
            ParameterValue[] parameterValues = new ParameterValue[]{new ParameterValue("Code", JDBCType.VARCHAR, this.codeProperty().get())};
            this.dataAccess.performDbOperation(query, parameterValues);
        }
        catch (Exception ex) {
            Logger.getLogger(CustomerPayment.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public Searchable getSearchable() {
        Searchable searchable = new Searchable();
        searchable.setTableName("CustomerPayment");
        String[] parameters = new String[]{"customerName", "code", "\"date\"", "amountPaid", "receivingStaff", "saleInvoiceNumber"};
        searchable.setParameters(parameters);
        return searchable;
    }

    @Override
    public void beforeInsert() {
    }

    @Override
    public void afterInsert() {
    }

    @Override
    public void beforeUpdate() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void afterUpdate() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void initializeListener() {
    }
}

