/*
 * Decompiled with CFR 0.152.
 */
package com.xputertechnologies.santa;

import com.xputertechnologies.santa.DbEntity;
import com.xputertechnologies.santa.SalesMode;
import com.xputertechnologies.santa.StockItem;
import com.xputertechnologies.santa.User;
import com.xputertechnologies.santa.core.BaseConcurrencyException;
import com.xputertechnologies.santa.core.ConsequentialConcurrencyException;
import com.xputertechnologies.santa.core.DataAccess;
import com.xputertechnologies.santa.core.DateOutOfSyncException;
import com.xputertechnologies.santa.core.ObjectState;
import com.xputertechnologies.santa.core.ParameterValue;
import com.xputertechnologies.santa.core.Searchable;
import com.xputertechnologies.santa.list.CompanyDataList;
import com.xputertechnologies.santa.list.StockItemList;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.sql.Date;
import java.sql.JDBCType;
import java.sql.SQLException;
import java.time.LocalDate;
import java.util.Calendar;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;

public class Company
extends DbEntity {
    public static final int MAXIMUM_NUMBER_OF_LOGIN_ATTEMPTS = 4;
    public static User currentUser;
    public Company vClone;
    private boolean isCloned;
    public DataAccess dataAccess = this.getDbAccess();
    double directQty;
    double notDirectQty;
    private StringProperty downloadUrl = new SimpleStringProperty();
    private StringProperty locationCode = new SimpleStringProperty();
    private BooleanProperty allowDirectPurchase = new SimpleBooleanProperty();
    private StringProperty b2bLocationCode = new SimpleStringProperty("");
    private BooleanProperty isMainHub = new SimpleBooleanProperty(false);
    private BooleanProperty isCloseOfBusiness = new SimpleBooleanProperty();
    private IntegerProperty directPurchaseDuration = new SimpleIntegerProperty();
    private DoubleProperty balanceBf = new SimpleDoubleProperty();
    private ObjectProperty<LocalDate> currentDay = new SimpleObjectProperty((Object)LocalDate.now());
    private Date CurrentDay;
    private StringProperty hubLocationCode = new SimpleStringProperty();
    private StringProperty name = new SimpleStringProperty();
    private StringProperty endPointOMS = new SimpleStringProperty();
    private StringProperty endPoint = new SimpleStringProperty("http://168.63.120.173:90/api");
    private StringProperty costCenter = new SimpleStringProperty("RST013");
    private StringProperty storeName = new SimpleStringProperty();
    private StringProperty storeCode = new SimpleStringProperty();
    private ObjectProperty<byte[]> logo = new SimpleObjectProperty();
    private StringProperty address = new SimpleStringProperty();
    private StringProperty salesMode = new SimpleStringProperty(SalesMode.Bargain.name());
    private IntegerProperty lastPaymentBatchCount = new SimpleIntegerProperty(1);
    private IntegerProperty numberOfReceipt = new SimpleIntegerProperty(1);
    private String invoiceNumber;
    private IntegerProperty lastTransactionCount = new SimpleIntegerProperty();
    private IntegerProperty lastInvoiceNumber = new SimpleIntegerProperty();
    private IntegerProperty lastTransferCount = new SimpleIntegerProperty();
    private IntegerProperty lastPurchaseCode = new SimpleIntegerProperty();
    private IntegerProperty lastIncomeExpenseCount = new SimpleIntegerProperty();

    public Company() {
    }

    public Company(String costCenter, String storeCode, String storeName, String name, byte[] logo, String address, SalesMode salesMode, int numberOfReceipt, int lastTransactionCount, int lastInvoiceNumber, int lastPurchaseCode, int lastIncomeExpenseCount, boolean allowDirectPurchase, int directPurchaseDuration, Date currentDay, double balanceBf, boolean isCloseOfBusiness, String downloadUrl, Integer lastTransferCount, Integer lastPaymentBatchCount, String locationCode, boolean isMainHub, String hubLocationCode, String b2bLocationCode, DataAccess dbAccess) {
        super(dbAccess);
        this.b2bLocationCode.set((Object)b2bLocationCode);
        this.isMainHub.set(isMainHub);
        this.hubLocationCode.set((Object)hubLocationCode);
        this.locationCode.set((Object)locationCode);
        this.lastTransferCount.set(lastTransferCount.intValue());
        this.lastPaymentBatchCount.set(lastPaymentBatchCount.intValue());
        this.dataAccess = dbAccess;
        this.costCenter.set((Object)costCenter);
        this.storeCode.set((Object)storeCode);
        this.balanceBf.set(balanceBf);
        this.name.set((Object)name);
        this.storeName.set((Object)storeName);
        this.logo.set((Object)logo);
        this.address.set((Object)address);
        this.salesMode.set((Object)salesMode.toString());
        this.numberOfReceipt.set(numberOfReceipt);
        this.lastTransactionCount.set(lastTransactionCount);
        this.lastInvoiceNumber.set(lastInvoiceNumber);
        this.lastPurchaseCode.set(lastPurchaseCode);
        this.lastIncomeExpenseCount.set(lastIncomeExpenseCount);
        this.allowDirectPurchase.set(allowDirectPurchase);
        this.directPurchaseDuration.set(directPurchaseDuration);
        this.currentDay.set((Object)currentDay.toLocalDate());
        this.isCloseOfBusiness.set(isCloseOfBusiness);
        this.downloadUrl.set((Object)downloadUrl);
        this.setState(ObjectState.Unchanged);
        this.setMustClone(true);
        this.initializeListener();
        this.vClone = this.clone();
    }

    public Company(String costCenter, String storeCode, String storeName, String name, byte[] logo, String address, SalesMode salesMode, int numberOfReceipt, int lastTransactionCount, int lastInvoiceNumber, int lastIncomeExpenseCount, Date currentDay, double balanceBf, boolean isCloseOfBusiness, boolean isMainHub, String hubLocationCode, String b2bLocationCode, DataAccess dbAccess) {
        super(dbAccess);
        this.b2bLocationCode.set((Object)b2bLocationCode);
        this.hubLocationCode.set((Object)hubLocationCode);
        this.isMainHub.set(isMainHub);
        this.dataAccess = dbAccess;
        this.costCenter.set((Object)costCenter);
        this.storeCode.set((Object)storeCode);
        this.balanceBf.set(balanceBf);
        this.name.set((Object)name);
        this.storeName.set((Object)storeName);
        this.logo.set((Object)logo);
        this.address.set((Object)address);
        this.salesMode.set((Object)salesMode.toString());
        this.numberOfReceipt.set(numberOfReceipt);
        this.lastTransactionCount.set(lastTransactionCount);
        this.lastInvoiceNumber.set(lastInvoiceNumber);
        this.lastIncomeExpenseCount.set(lastIncomeExpenseCount);
        this.currentDay.set((Object)currentDay.toLocalDate());
        this.isCloseOfBusiness.set(isCloseOfBusiness);
        this.setState(ObjectState.Unchanged);
        this.setMustClone(true);
        this.initializeListener();
        this.vClone = this.clone();
    }

    public Company(DataAccess dbAccess) {
        super(dbAccess);
    }

    public StringProperty downloadUrlProperty() {
        return this.downloadUrl;
    }

    public String getDownloadUrl() {
        return (String)this.downloadUrl.get();
    }

    public void setDownloadUrl(String downloadUrl) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.clone();
        }
        this.changeObjectState();
        this.downloadUrl.set((Object)downloadUrl);
    }

    public StringProperty locationCodeProperty() {
        return this.locationCode;
    }

    public String getLocationCode() {
        return (String)this.locationCode.get();
    }

    public void setLocationCode(String locationCode) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.clone();
        }
        this.changeObjectState();
        this.locationCode.set((Object)locationCode);
    }

    public boolean getAllowDirectPurchase() {
        return this.allowDirectPurchase.get();
    }

    public void setAllowDirectPurchase(boolean allowDirectPurchase) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.clone();
        }
        this.allowDirectPurchase.set(allowDirectPurchase);
        this.changeObjectState();
    }

    public BooleanProperty allowDirectPurchaseProperty() {
        return this.allowDirectPurchase;
    }

    public StringProperty b2bLocationCodeProperty() {
        return this.b2bLocationCode;
    }

    public String getB2bLocationCode() {
        return (String)this.b2bLocationCode.get();
    }

    public void setB2bLocationCode(String b2bLocationCode) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.clone();
        }
        this.b2bLocationCode.set((Object)b2bLocationCode);
        this.changeObjectState();
    }

    public BooleanProperty isMainHubProperty() {
        return this.isMainHub;
    }

    public boolean getIsMainHub() {
        return this.isMainHub.get();
    }

    public void setIsMainHub(boolean isMainHub) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.clone();
        }
        this.isMainHub.set(isMainHub);
        this.changeObjectState();
    }

    public boolean getCloseOfBusiness() {
        return this.isCloseOfBusiness.get();
    }

    public void setCloseOfBusiness(boolean isCloseOfBusiness) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.clone();
        }
        this.isCloseOfBusiness.set(isCloseOfBusiness);
        this.changeObjectState();
    }

    public BooleanProperty isCloseOfBusinessProperty() {
        return this.isCloseOfBusiness;
    }

    public int getDirectPurchaseDuration() {
        return this.directPurchaseDuration.get();
    }

    public void setDirectPurchaseDuration(int directPurchaseDuration) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.clone();
        }
        this.changeObjectState();
        this.directPurchaseDuration.set(directPurchaseDuration);
    }

    public DoubleProperty balanceBfProperty() {
        return this.balanceBf;
    }

    public double getBalanceBf() {
        return this.balanceBf.get();
    }

    public LocalDate getCurrentDay() {
        return (LocalDate)this.currentDay.get();
    }

    public ObjectProperty<LocalDate> currentDayProperty() {
        return this.currentDay;
    }

    public void setBalanceBf(double balanceBf) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.clone();
        }
        this.balanceBf.set(balanceBf);
        this.changeObjectState();
    }

    public boolean businessClose() {
        CompanyDataList companyDataList = new CompanyDataList(this.dataAccess);
        companyDataList.selectAll("Select * From Company ", this.dataAccess.getEmptyParameterValues());
        return ((Company)companyDataList.getOriginalList().get((int)0)).isCloseOfBusiness.get();
    }

    public void updateBusinessClose() {
        CompanyDataList companyDataList = new CompanyDataList(this.dataAccess);
        companyDataList.selectAll("Select * From Company ", this.dataAccess.getEmptyParameterValues());
        if (((Company)companyDataList.getOriginalList().get((int)0)).isCloseOfBusiness.get()) {
            Calendar calEarliest = Calendar.getInstance();
            calEarliest.setTime(Date.valueOf((LocalDate)((Company)companyDataList.getOriginalList().get((int)0)).currentDay.get()));
            Calendar calLatest = Calendar.getInstance();
            calLatest.setTime(Date.valueOf(LocalDate.now()));
            int b = calEarliest.getTime().compareTo(Date.valueOf(LocalDate.now()));
            if (b == -1) {
                try {
                    switch (Date.valueOf(LocalDate.now()).getDay()) {
                        case 0: {
                            if (((LocalDate)((Company)companyDataList.getOriginalList().get((int)0)).currentDay.get()).getDayOfMonth() >= 5) {
                                this.setCurrentDay(LocalDate.now());
                                ((Company)companyDataList.getOriginalList().get(0)).setCloseOfBusiness(false);
                                companyDataList.update();
                            }
                            break;
                        }
                        case 1: {
                            if (((LocalDate)((Company)companyDataList.getOriginalList().get((int)0)).currentDay.get()).getDayOfMonth() >= 5 || ((LocalDate)((Company)companyDataList.getOriginalList().get((int)0)).currentDay.get()).getDayOfMonth() == 0) {
                                this.setCurrentDay(LocalDate.now());
                                ((Company)companyDataList.getOriginalList().get(0)).setCloseOfBusiness(false);
                                companyDataList.update();
                            }
                            break;
                        }
                        case 2: {
                            if (((LocalDate)((Company)companyDataList.getOriginalList().get((int)0)).currentDay.get()).getDayOfMonth() == 1) {
                                this.setCurrentDay(LocalDate.now());
                                ((Company)companyDataList.getOriginalList().get(0)).setCloseOfBusiness(false);
                                companyDataList.update();
                            }
                            break;
                        }
                        case 3: {
                            if (((LocalDate)((Company)companyDataList.getOriginalList().get((int)0)).currentDay.get()).getDayOfMonth() == 2) {
                                this.setCurrentDay(LocalDate.now());
                                ((Company)companyDataList.getOriginalList().get(0)).setCloseOfBusiness(false);
                                companyDataList.update();
                            }
                            break;
                        }
                        case 4: {
                            if (((LocalDate)((Company)companyDataList.getOriginalList().get((int)0)).currentDay.get()).getDayOfMonth() == 3) {
                                this.setCurrentDay(LocalDate.now());
                                ((Company)companyDataList.getOriginalList().get(0)).setCloseOfBusiness(false);
                                companyDataList.update();
                            }
                            break;
                        }
                        case 5: {
                            if (((LocalDate)((Company)companyDataList.getOriginalList().get((int)0)).currentDay.get()).getDayOfMonth() == 4) {
                                this.setCurrentDay(LocalDate.now());
                                ((Company)companyDataList.getOriginalList().get(0)).setCloseOfBusiness(false);
                                companyDataList.update();
                            }
                            break;
                        }
                        case 6: {
                            if (((LocalDate)((Company)companyDataList.getOriginalList().get((int)0)).currentDay.get()).getDayOfMonth() == 5) {
                                this.setCurrentDay(LocalDate.now());
                                ((Company)companyDataList.getOriginalList().get(0)).setCloseOfBusiness(false);
                                companyDataList.update();
                            }
                            break;
                        }
                        default: {
                            throw new DateOutOfSyncException();
                        }
                    }
                }
                catch (Exception ex) {
                    Logger.getLogger(Company.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
    }

    public void setCurrentDay(LocalDate date) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.clone();
        }
        this.changeObjectState();
        this.currentDay.set((Object)date);
    }

    public String getHubLocationCode() {
        return (String)this.hubLocationCode.get();
    }

    public StringProperty hubLocationCodeProperty() {
        return this.hubLocationCode;
    }

    public void setHubLocationCode(String hubLocationCode) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.clone();
        }
        this.hubLocationCode.set((Object)hubLocationCode);
        this.changeObjectState();
    }

    public String getName() {
        return (String)this.name.get();
    }

    public StringProperty nameProperty() {
        return this.name;
    }

    public void setName(String name) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.clone();
        }
        this.name.set((Object)name);
        this.changeObjectState();
    }

    public StringProperty endPointOMSProperty() {
        return this.endPointOMS;
    }

    public String getEndPointOMS() {
        return (String)this.endPointOMS.get();
    }

    public void setEndPointOMS(String endPointOMS) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.clone();
        }
        this.changeObjectState();
        this.endPointOMS.set((Object)endPointOMS);
    }

    public StringProperty endPointProperty() {
        return this.endPoint;
    }

    public String getEndPoint() {
        return (String)this.endPoint.get();
    }

    public void setEndPoint(String endPoint) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.clone();
        }
        this.changeObjectState();
        this.endPoint.set((Object)endPoint);
    }

    public String getCostCenter() {
        return (String)this.costCenter.get();
    }

    public StringProperty costCenterProperty() {
        return this.costCenter;
    }

    public void setCostCenter(String costCenter) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.clone();
        }
        this.costCenter.set((Object)costCenter);
        this.changeObjectState();
    }

    public String getStoreName() {
        return (String)this.storeName.get();
    }

    public StringProperty storeNameProperty() {
        return this.storeName;
    }

    public void setStoreName(String storeName) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.clone();
        }
        this.storeName.set((Object)storeName);
        this.changeObjectState();
    }

    public String getStoreCode() {
        return (String)this.storeCode.get();
    }

    public StringProperty storeCodeProperty() {
        return this.storeCode;
    }

    public void setStoreCode(String storeCode) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.clone();
        }
        this.storeCode.set((Object)storeCode);
        this.changeObjectState();
    }

    public ObjectProperty<byte[]> logoProperty() {
        return this.logo;
    }

    public byte[] getLogo() {
        return (byte[])this.logo.get();
    }

    public void setLogo(byte[] logo) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.clone();
        }
        this.logo.set((Object)logo);
        this.changeObjectState();
    }

    public String getAddress() {
        return (String)this.address.get();
    }

    public void setAddress(String address) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.clone();
        }
        this.address.set((Object)address);
        this.changeObjectState();
    }

    public StringProperty addressProperty() {
        return this.address;
    }

    public StringProperty salesModeProperty() {
        return this.salesMode;
    }

    public String getSalesMode() {
        return (String)this.salesMode.get();
    }

    public void setSalesMode(SalesMode salesMode) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.clone();
        }
        this.salesMode.set((Object)salesMode.toString());
        this.changeObjectState();
    }

    public int getLastPaymentBatchCount() {
        return this.lastPaymentBatchCount.get();
    }

    public void setLastPaymentBatchCount(int lastPaymentBatchCount) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.clone();
        }
        this.lastPaymentBatchCount.set(lastPaymentBatchCount);
        this.changeObjectState();
    }

    public IntegerProperty lastPaymentBatchCountProperty() {
        return this.lastPaymentBatchCount;
    }

    public int getNumberOfReceipt() {
        return this.numberOfReceipt.get();
    }

    public void setNumberOfReceipt(int numberOfReceipt) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.clone();
        }
        this.numberOfReceipt.set(numberOfReceipt);
        this.changeObjectState();
    }

    public IntegerProperty numberOfReceiptProperty() {
        return this.numberOfReceipt;
    }

    public IntegerProperty directPurchaseDurationProperty() {
        return this.directPurchaseDuration;
    }

    public String getInvoiceNo() {
        return this.invoiceNumber;
    }

    public void setInvoiceNo(String invoiceNumber) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.clone();
        }
        this.invoiceNumber = invoiceNumber;
        this.changeObjectState();
    }

    public int getLastTransactionCount() {
        return this.lastTransactionCount.get();
    }

    public void setLastTransactionCount(int lastTransactionCount) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.clone();
        }
        this.lastTransactionCount.set(lastTransactionCount);
        this.changeObjectState();
    }

    public IntegerProperty lastTransactionCountProperty() {
        return this.lastTransactionCount;
    }

    public int getLastInvoiceNumber() {
        return this.lastInvoiceNumber.get();
    }

    public void setLastInvoiceNumber(int lastInvoiceNumber) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.clone();
        }
        this.lastInvoiceNumber.set(lastInvoiceNumber);
        this.changeObjectState();
    }

    public IntegerProperty lastInvoiceNumberProperty() {
        return this.lastInvoiceNumber;
    }

    public int getLastTransferCount() {
        return this.lastTransferCount.get();
    }

    public void setLastTransferCount(int lastTransferCount) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.clone();
        }
        this.lastTransferCount.set(lastTransferCount);
        this.changeObjectState();
    }

    public IntegerProperty lastTransferCountProperty() {
        return this.lastTransferCount;
    }

    public int getLastPurchaseCode() {
        return this.lastPurchaseCode.get();
    }

    public void setLastPurchaseCode(int lastPurchaseCode) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.clone();
        }
        this.lastPurchaseCode.set(lastPurchaseCode);
        this.changeObjectState();
    }

    public IntegerProperty lastPurchaseCodeProperty() {
        return this.lastPurchaseCode;
    }

    public int getLastIncomeExpenseCount() {
        return this.lastIncomeExpenseCount.get();
    }

    public void setLastIncomeExpenseCount(int lastIncomeExpenseCount) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.clone();
        }
        this.lastIncomeExpenseCount.set(lastIncomeExpenseCount);
        this.changeObjectState();
    }

    public IntegerProperty lastIncomeExpenseCountProperty() {
        return this.lastIncomeExpenseCount;
    }

    public static long daysBetween(Calendar earliestDate, Calendar latestDate) {
        long daysBetween = 0L;
        Calendar cloneEarliestDate = (Calendar)earliestDate.clone();
        while (cloneEarliestDate.before(latestDate)) {
            cloneEarliestDate.add(5, 1);
            ++daysBetween;
        }
        return daysBetween;
    }

    public void synchronizeCurrentDay() throws DateOutOfSyncException {
        block21: {
            try {
                Calendar calEarliest = Calendar.getInstance();
                calEarliest.setTime(Date.valueOf((LocalDate)this.currentDay.get()));
                Calendar calLatest = Calendar.getInstance();
                calLatest.setTime(Date.valueOf(LocalDate.now()));
                int b = ((LocalDate)this.currentDay.get()).compareTo(LocalDate.now());
                if (b == -1 || b == 1) {
                    long days = Company.daysBetween(calEarliest, calLatest);
                    if (days > -1L && days <= 3L) {
                        CompanyDataList companyDataList = new CompanyDataList(this.dataAccess);
                        companyDataList.getOriginalList().add((Object)this);
                        switch (Date.valueOf(LocalDate.now()).getDay()) {
                            case 0: {
                                if (((LocalDate)this.currentDay.get()).getDayOfMonth() >= 5) {
                                    this.setCurrentDay(LocalDate.now());
                                    companyDataList.update();
                                    break;
                                }
                                throw new DateOutOfSyncException();
                            }
                            case 1: {
                                if (((LocalDate)this.currentDay.get()).getDayOfMonth() >= 5 || ((LocalDate)this.currentDay.get()).getDayOfMonth() == 0) {
                                    this.setCurrentDay(LocalDate.now());
                                    companyDataList.update();
                                    break;
                                }
                                throw new DateOutOfSyncException();
                            }
                            case 2: {
                                if (((LocalDate)this.currentDay.get()).getDayOfMonth() == 1) {
                                    this.setCurrentDay(LocalDate.now());
                                    companyDataList.update();
                                    break;
                                }
                                throw new DateOutOfSyncException();
                            }
                            case 3: {
                                if (((LocalDate)this.currentDay.get()).getDayOfMonth() == 2) {
                                    this.setCurrentDay(LocalDate.now());
                                    companyDataList.update();
                                    break;
                                }
                                throw new DateOutOfSyncException();
                            }
                            case 4: {
                                if (((LocalDate)this.currentDay.get()).getDayOfMonth() == 3) {
                                    this.setCurrentDay(LocalDate.now());
                                    companyDataList.update();
                                    break;
                                }
                                throw new DateOutOfSyncException();
                            }
                            case 5: {
                                if (((LocalDate)this.currentDay.get()).getDayOfMonth() == 4) {
                                    this.setCurrentDay(LocalDate.now());
                                    companyDataList.update();
                                    break;
                                }
                                throw new DateOutOfSyncException();
                            }
                            case 6: {
                                if (((LocalDate)this.currentDay.get()).getDayOfMonth() == 5) {
                                    this.setCurrentDay(LocalDate.now());
                                    companyDataList.update();
                                    break;
                                }
                                throw new DateOutOfSyncException();
                            }
                            default: {
                                throw new DateOutOfSyncException();
                            }
                        }
                        break block21;
                    }
                    throw new DateOutOfSyncException();
                }
                if (b == 0) {
                    return;
                }
                throw new DateOutOfSyncException();
            }
            catch (Exception e) {
                if (!(e instanceof DateOutOfSyncException)) break block21;
                throw new DateOutOfSyncException();
            }
        }
    }

    public ObservableList<StockItem> loadOutstandingItems() throws SQLException {
        String query = "Select * From StockItem Where directPurchaseQty>0 ";
        StockItemList directPurchaseQtyStockItems = new StockItemList(this.dataAccess);
        directPurchaseQtyStockItems.selectAll(query, this.dataAccess.getEmptyParameterValues());
        return directPurchaseQtyStockItems.getOriginalList();
    }

    public static void writeToconnectPathFile(String PreLoadstringFile, String stringFile) throws FileNotFoundException, IOException {
        File file = new File("ConnectionPath.txt");
        FileOutputStream fileOut = new FileOutputStream(file.getAbsolutePath().replace("ConnectionPath.txt", "") + "src\\com\\xputertechnologies\\santa\\ui\\ConnectionPath.txt");
        BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(fileOut));
        bw.write(PreLoadstringFile);
        bw.newLine();
        bw.write(stringFile);
        bw.close();
    }

    public Company clone() {
        Company company = new Company();
        this.setMustClone(false);
        company.b2bLocationCode.set((Object)((String)this.b2bLocationCode.get()));
        company.isMainHub.set(this.isMainHub.get());
        company.hubLocationCode.set((Object)((String)this.hubLocationCode.get()));
        company.costCenter.set((Object)((String)this.costCenter.get()));
        company.storeCode.set((Object)((String)this.storeCode.get()));
        company.name.set((Object)((String)this.name.get()));
        company.storeName.set((Object)((String)this.storeName.get()));
        company.address.set((Object)((String)this.address.get()));
        company.logo.set((Object)((byte[])this.logo.get()));
        company.numberOfReceipt.set(this.numberOfReceipt.get());
        company.salesMode.set((Object)((String)this.salesMode.get()));
        company.lastIncomeExpenseCount.set(this.lastIncomeExpenseCount.get());
        company.lastInvoiceNumber.set(this.lastIncomeExpenseCount.get());
        company.lastPurchaseCode.set(this.lastPurchaseCode.get());
        company.lastTransactionCount.set(this.lastTransactionCount.get());
        company.allowDirectPurchase.set(this.allowDirectPurchase.get());
        company.directPurchaseDuration.set(this.directPurchaseDuration.get());
        company.currentDay.set((Object)((LocalDate)this.currentDay.get()));
        company.balanceBf.set(this.balanceBf.get());
        company.downloadUrl.set((Object)((String)this.downloadUrl.get()));
        company.isCloseOfBusiness.set(this.isCloseOfBusiness.get());
        company.lastTransferCount.set(this.lastTransferCount.get());
        company.lastPaymentBatchCount.set(this.lastPaymentBatchCount.get());
        company.locationCode.set((Object)((String)this.locationCode.get()));
        this.setMustClone(true);
        this.isCloned = true;
        return company;
    }

    protected void rollBack() {
        this.b2bLocationCode.set((Object)((String)this.vClone.b2bLocationCode.get()));
        this.isMainHub.set(this.vClone.isMainHub.get());
        this.hubLocationCode.set((Object)((String)this.vClone.hubLocationCode.get()));
        this.storeCode.set((Object)((String)this.vClone.storeCode.get()));
        this.costCenter.set((Object)((String)this.vClone.costCenter.get()));
        this.name.set((Object)((String)this.vClone.name.get()));
        this.storeName.set((Object)((String)this.vClone.storeName.get()));
        this.address.set((Object)((String)this.vClone.address.get()));
        this.logo.set((Object)((byte[])this.vClone.logo.get()));
        this.numberOfReceipt.set(this.vClone.numberOfReceipt.get());
        this.salesMode.set((Object)((String)this.vClone.salesMode.get()));
        this.lastIncomeExpenseCount.set(this.vClone.lastIncomeExpenseCount.get());
        this.lastInvoiceNumber.set(this.vClone.lastInvoiceNumber.get());
        this.lastPurchaseCode.set(this.vClone.lastPurchaseCode.get());
        this.lastTransactionCount.set(this.vClone.lastTransactionCount.get());
        this.allowDirectPurchase.set(this.vClone.allowDirectPurchase.get());
        this.directPurchaseDuration.set(this.vClone.directPurchaseDuration.get());
        this.currentDay.set((Object)((LocalDate)this.vClone.currentDay.get()));
        this.balanceBf.set(this.vClone.balanceBf.get());
        this.downloadUrl.set((Object)((String)this.vClone.downloadUrl.get()));
        this.lastTransferCount.set(this.vClone.lastTransferCount.get());
        this.isCloseOfBusiness.set(this.vClone.isCloseOfBusiness.get());
        this.lastPaymentBatchCount.set(this.vClone.lastPaymentBatchCount.get());
        this.locationCode.set((Object)((String)this.vClone.locationCode.get()));
        this.setMustClone(true);
    }

    @Override
    public void setDbAccess(DataAccess db) {
        this.dataAccess = db;
    }

    @Override
    public void insert() throws Exception {
        try {
            String query = "INSERT INTO COMPANY(costCenter,storeCode,storeName,name,address,logo,numberOfReceipt,modeType,lastIncomeExpenseCount,lastInvoiceNumber,lastPurchaseCode,lastTransactionCount,allowDirectPurchase,directPurchaseDuration,currentDay,balanceBf,isCloseOfBusiness,downloadUrl,lastTransferCount,lastPaymentBatchCount,locationCode,isMainHub,hubLocationCode,b2bLocationCode) Values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
            ParameterValue[] parameterValues = new ParameterValue[]{new ParameterValue("costCenter", JDBCType.VARCHAR, this.costCenter.get()), new ParameterValue("storeCode", JDBCType.VARCHAR, this.storeCode.get()), new ParameterValue("storeName", JDBCType.VARCHAR, this.storeName.get()), new ParameterValue("name", JDBCType.VARCHAR, this.name.get()), new ParameterValue("address", JDBCType.VARCHAR, this.address.get()), new ParameterValue("logo", JDBCType.BINARY, this.logo.get()), new ParameterValue("numberOfReceipt", JDBCType.INTEGER, this.numberOfReceipt.get()), new ParameterValue("modeType", JDBCType.VARCHAR, this.salesMode.get()), new ParameterValue("lastIncomeExpenseCount", JDBCType.INTEGER, this.lastIncomeExpenseCount.get()), new ParameterValue("lastInvoiceNumber", JDBCType.INTEGER, this.lastInvoiceNumber.get()), new ParameterValue("lastPurchaseCode", JDBCType.INTEGER, this.lastPurchaseCode.get()), new ParameterValue("lastTransaction", JDBCType.INTEGER, this.lastTransactionCount.get()), new ParameterValue("allowDirectPurchase", JDBCType.CHAR, this.allowDirectPurchase.get()), new ParameterValue("directPurchaseDuration", JDBCType.INTEGER, this.directPurchaseDuration.get()), new ParameterValue("currentDay", JDBCType.DATE, Date.valueOf((LocalDate)this.currentDay.get())), new ParameterValue("balanceBf", JDBCType.DOUBLE, this.balanceBf.get()), new ParameterValue("isCloseOfBusiness", JDBCType.CHAR, this.isCloseOfBusiness.get()), new ParameterValue("downloadUrl", JDBCType.VARCHAR, this.downloadUrl.get()), new ParameterValue("lastTransferCount", JDBCType.INTEGER, this.lastTransferCount.get()), new ParameterValue("lastPaymentBatchCount", JDBCType.INTEGER, this.lastPaymentBatchCount.get()), new ParameterValue("locationCode", JDBCType.VARCHAR, this.locationCode.get()), new ParameterValue("isMainHub", JDBCType.CHAR, this.isMainHub.get()), new ParameterValue("hubLocationCode", JDBCType.VARCHAR, this.hubLocationCode.get()), new ParameterValue("b2bLocationCode", JDBCType.VARCHAR, this.b2bLocationCode.get())};
            this.dataAccess.performDbOperation(query, parameterValues);
            this.vClone = this.clone();
        }
        catch (Exception e) {
            this.rollBack();
            this.isCloned = false;
            try {
                throw e;
            }
            catch (Exception ex) {
                Logger.getLogger(Company.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    @Override
    public void update() throws ConsequentialConcurrencyException, Exception {
        try {
            String query = "UPDATE COMPANY SET costCenter=?, storeCode=?, storeName=?, name=?,address=?,logo=?,numberOfReceipt=?,modeType=?,lastIncomeExpenseCount=?,lastInvoiceNumber=?,lastPurchaseCode=?,lastTransactionCount=?,allowDirectPurchase=?,directPurchaseDuration=?,currentDay=?,balanceBf=?,isCloseOfBusiness=?,downloadUrl=?,lastTransferCount=?,lastPaymentBatchCount=?, locationCode=?,isMainHub=?,hubLocationCode=?, b2bLocationCode=? WHERE name=?";
            ParameterValue[] parameterValues = new ParameterValue[]{new ParameterValue("costCenter", JDBCType.VARCHAR, this.costCenter.get()), new ParameterValue("storeCode", JDBCType.VARCHAR, this.storeCode.get()), new ParameterValue("storeName", JDBCType.VARCHAR, this.storeName.get()), new ParameterValue("name", JDBCType.VARCHAR, this.name.get()), new ParameterValue("address", JDBCType.VARCHAR, this.address.get()), new ParameterValue("logo", JDBCType.BINARY, this.logo.get()), new ParameterValue("numberOfReceipt", JDBCType.INTEGER, this.numberOfReceipt.get()), new ParameterValue("salesMode", JDBCType.VARCHAR, this.salesMode.get()), new ParameterValue("lastIncomeExpenseCount", JDBCType.INTEGER, this.lastIncomeExpenseCount.get()), new ParameterValue("lastInvoiceNumber", JDBCType.INTEGER, this.lastInvoiceNumber.get()), new ParameterValue("lastPurchaseCode", JDBCType.INTEGER, this.lastPurchaseCode.get()), new ParameterValue("lastTransaction", JDBCType.INTEGER, this.lastTransactionCount.get()), new ParameterValue("allowDirectPurchase", JDBCType.CHAR, this.allowDirectPurchase.get()), new ParameterValue("directPurchaseDuration", JDBCType.INTEGER, this.directPurchaseDuration.get()), new ParameterValue("currentDay", JDBCType.DATE, Date.valueOf((LocalDate)this.currentDay.get())), new ParameterValue("balanceBf", JDBCType.DOUBLE, this.balanceBf.get()), new ParameterValue("isCloseOfBusiness", JDBCType.CHAR, this.isCloseOfBusiness.get()), new ParameterValue("downloadUrl", JDBCType.VARCHAR, this.downloadUrl.get()), new ParameterValue("lastTransferCount", JDBCType.INTEGER, this.lastTransferCount.get()), new ParameterValue("lastPaymentBatchCount", JDBCType.INTEGER, this.lastPaymentBatchCount.get()), new ParameterValue("locationCode", JDBCType.VARCHAR, this.locationCode.get()), new ParameterValue("isMainHub", JDBCType.CHAR, this.isMainHub.get()), new ParameterValue("hubLocationCode", JDBCType.VARCHAR, this.hubLocationCode.get()), new ParameterValue("b2bLocationCode", JDBCType.VARCHAR, this.b2bLocationCode.get()), new ParameterValue("vCloneName", JDBCType.VARCHAR, this.vClone.name.get())};
            this.dataAccess.performDbOperation(query, parameterValues, true);
            this.vClone = this.clone();
        }
        catch (Exception e) {
            if (e instanceof BaseConcurrencyException) {
                String message = e.getMessage();
                throw new ConsequentialConcurrencyException(message, (Object)null);
            }
            throw e;
        }
    }

    @Override
    public void delete() throws Exception {
        try {
            String query = "DELETE FROM COMPANY WHERE name=?";
            ParameterValue[] parameterValues = new ParameterValue[]{new ParameterValue("name", JDBCType.VARCHAR, this.name)};
            this.dataAccess.performDbOperation(query, parameterValues);
        }
        catch (Exception ex) {
            Logger.getLogger(Company.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public Searchable getSearchable() {
        Searchable searchable = new Searchable();
        searchable.setTableName("Company");
        String[] parameters = new String[]{"name", "storeName", "address", "modeType"};
        searchable.setParameters(parameters);
        return searchable;
    }

    @Override
    public void beforeInsert() {
    }

    @Override
    public void afterInsert() {
        this.setState(ObjectState.Unchanged);
    }

    @Override
    public void beforeUpdate() {
    }

    @Override
    public void afterUpdate() {
        this.setState(ObjectState.Unchanged);
    }

    @Override
    public void initializeListener() {
        this.name.addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                Company.this.setName(newValue);
            }
        });
        this.logo.addListener((ChangeListener)new ChangeListener<byte[]>(){

            public void changed(ObservableValue<? extends byte[]> observable, byte[] oldValue, byte[] newValue) {
                if (!Company.this.isConstructor) {
                    Company.this.setLogo(newValue);
                }
            }
        });
        this.address.addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                Company.this.setAddress(newValue);
            }
        });
        this.salesMode.addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                Company.this.setSalesMode(SalesMode.valueOf(newValue));
            }
        });
        this.numberOfReceipt.addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                Company.this.setNumberOfReceipt((Integer)newValue);
            }
        });
        this.lastTransactionCount.addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                Company.this.setLastTransactionCount((Integer)newValue);
            }
        });
        this.lastInvoiceNumber.addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                Company.this.setLastInvoiceNumber((Integer)newValue);
            }
        });
        this.lastPurchaseCode.addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                Company.this.setLastPurchaseCode((Integer)newValue);
            }
        });
        this.lastIncomeExpenseCount.addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                Company.this.setLastIncomeExpenseCount((Integer)newValue);
            }
        });
        this.allowDirectPurchase.addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                Company.this.setAllowDirectPurchase(newValue);
            }
        });
        this.isMainHub.addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                Company.this.setIsMainHub(newValue);
            }
        });
        this.directPurchaseDuration.addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                Company.this.setDirectPurchaseDuration((Integer)newValue);
            }
        });
        this.currentDay.addListener((ChangeListener)new ChangeListener<LocalDate>(){

            public void changed(ObservableValue<? extends LocalDate> observable, LocalDate oldValue, LocalDate newValue) {
                Company.this.setCurrentDay(newValue);
            }
        });
        this.storeName.addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                Company.this.setStoreName(newValue);
            }
        });
        this.storeCode.addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                Company.this.setStoreCode(newValue);
            }
        });
        this.costCenter.addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                Company.this.setCostCenter(newValue);
            }
        });
        this.downloadUrl.addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                Company.this.setDownloadUrl(newValue);
            }
        });
        this.locationCode.addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                Company.this.setLocationCode(newValue);
            }
        });
        this.hubLocationCode.addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                Company.this.setHubLocationCode(newValue);
            }
        });
        this.b2bLocationCode.addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                Company.this.setB2bLocationCode(newValue);
            }
        });
    }
}

